<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn xs">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>
<xsl:import href="from/title_tstv.xsl"/>

<xsl:output method="xml" indent="yes"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'TITLE']">
	<AMS xsl:use-attribute-sets="AmsAttributeSet" >
		<xsl:attribute name="Asset_Class">
			<xsl:choose>
					<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">title</xsl:when>
					<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</AMS>
	
	<!-- Type -->
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Type</xsl:attribute>
		<xsl:attribute name="Value">title</xsl:attribute>
	</App_Data>
	
	<!-- Title_Sort_Name -->
	<xsl:if test="tns:Fields/tns:Title/tns:SortTitle">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Title_Sort_Name</xsl:attribute>
		<xsl:attribute name="Value">
			<xsl:value-of select="tns:Fields/tns:Title/tns:SortTitle/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Subscriber_View_Limit -->
	<xsl:for-each select="tns:Fields/tns:Rights/tns:MaxViewLimit">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Subscriber_View_Limit</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="." />
		</xsl:attribute>
	</App_Data>
	</xsl:for-each>
	
	<!--  Title_Brief -->
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Title_Brief</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Title/tns:ShortTitle/tns:Value" />
		</xsl:attribute>
	</App_Data>
	
	<!-- Title -->
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet TitleAttribute" />
	
	<!-- ISAN -->
	<xsl:if test="tns:Fields/tns:ISAN">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">ISAN</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:ISAN" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Episode_Name -->
	<xsl:if test="tns:Fields/tns:Episode/tns:Name">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Episode_Name</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Episode/tns:Name/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Episode_ID -->
	<xsl:if test="tns:Fields/tns:Episode/tns:Number">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Episode_ID</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Episode/tns:Number" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Summary_Long -->
	<xsl:if test="tns:Fields/tns:Summary/tns:DisplaySummary">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Summary_Long</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Summary/tns:DisplaySummary/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!-- Summary_Medium -->
	<xsl:if test="tns:Fields/tns:Summary/tns:MediumSummary">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Summary_Medium</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Summary/tns:MediumSummary/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!-- Summary_Short -->
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ShortSummaryAttribute" />
	
	<!--  Rating -->
	<xsl:for-each select="tns:Fields/tns:Rating/tns:Value">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
			<xsl:attribute name="Name">Rating</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!-- MSORating -->
	<xsl:for-each select="tns:Fields/tns:Rating/tns:MSORating">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
			<xsl:attribute name="Name">MSORating</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!--  Advisories -->
	<xsl:for-each select="tns:Fields/tns:Rating/tns:ContentAdvisory">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
			<xsl:attribute name="Name">Advisories</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!--  Audience -->
	<xsl:for-each select="tns:Fields/tns:Rating/tns:TargetAudience">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
			<xsl:attribute name="Name">Audience</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!-- Caption -->
	<xsl:if test="tns:Fields/tns:Caption">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet CaptionAttribute" />
	</xsl:if>
	
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet RunTimeAttribute" />
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet DisplayRunTimeAttribute" />

	<xsl:if test="tns:Fields/tns:CreationInfo/tns:PublicationDate">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet YearAttribute" />
	</xsl:if>

	<!--  Country_of_Origin -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Place/tns:Country">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Country_of_Origin</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Place/tns:Country" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<xsl:for-each select="tns:Fields/tns:Source">
		<App_Data>
			<xsl:attribute name="App">
				<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
			</xsl:attribute>

			<xsl:choose>
				<xsl:when test="tns:Contact/tns:DisplayName">
					<xsl:attribute name="Name">
						<xsl:choose>
							<xsl:when test="tns:Role/tns:Name = 'ACTOR'">Actors_Display</xsl:when>
							<xsl:when test="tns:Role/tns:Name = 'WRITER'">Writer_Display</xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="tns:Contact/tns:DisplayName" />
					</xsl:attribute>
				</xsl:when>
				<xsl:when test="tns:Contact/tns:LastName">
					<xsl:attribute name="Name">
						<xsl:choose>
							<xsl:when test="tns:Role/tns:Name = 'ACTOR'">Actors</xsl:when>
							<xsl:when test="tns:Role/tns:Name = 'DIRECTOR'">Director</xsl:when>
							<xsl:when test="tns:Role/tns:Name = 'PRODUCER'">Producers</xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="Value">
						<xsl:choose>
							<xsl:when test="fn:normalize-space(tns:Contact/tns:FirstName) = ''">
								<xsl:value-of select="tns:Contact/tns:LastName" />							
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="tns:Contact/tns:LastName" />,<xsl:value-of select="tns:Contact/tns:FirstName"></xsl:value-of>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</xsl:when>
			</xsl:choose>

		</App_Data>
	</xsl:for-each>
	
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet StudioAttribute" />
	</xsl:if>
	
	<!-- Category -->
	<xsl:for-each select="tns:Fields/tns:Category">
		<App_Data>
			<xsl:attribute name="App">
				<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
			</xsl:attribute>
			<xsl:attribute name="Name">Category</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="fn:substring(tns:Text, 1, 256)" />
			</xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!--  Season_Premiere -->
	<xsl:if test="tns:Fields/tns:Episode/tns:SeasonPremier">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Season_Premiere</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case(tns:Fields/tns:Episode/tns:SeasonPremier) = 'true'">Y</xsl:when>
					<xsl:when test="fn:lower-case(tns:Fields/tns:Episode/tns:SeasonPremier) = 'false'">N</xsl:when>
					<xsl:otherwise><xsl:value-of select="tns:Fields/tns:Episode/tns:SeasonPremier" /></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!--  Season_Finale -->
	<xsl:if test="tns:Fields/tns:Episode/tns:SeasonFinale">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Season_Finale</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case(tns:Fields/tns:Episode/tns:SeasonFinale) = 'true'">Y</xsl:when>
					<xsl:when test="fn:lower-case(tns:Fields/tns:Episode/tns:SeasonFinale) = 'false'">N</xsl:when>
					<xsl:otherwise><xsl:value-of select="tns:Fields/tns:Episode/tns:SeasonFinale" /></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Genre -->
	<xsl:for-each select="tns:Fields/tns:Genre">
	<App_Data>
		<xsl:attribute name="App">
			<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
		</xsl:attribute>
		<xsl:attribute name="Name">Genre</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:for-each>

	<!--  Show_Type -->
	<xsl:if test="tns:Fields/tns:ShowType">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Show_Type</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:ShowType" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>

	<!--  Chapter -->
	<xsl:for-each select="tns:Fields/tns:Chapter">
	<App_Data>
		<xsl:attribute name="App">
			<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
		</xsl:attribute>
		<xsl:attribute name="Name">Chapter</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="." />
		</xsl:attribute>
	</App_Data>
	</xsl:for-each>

	<!-- Box_Office -->
	<xsl:if test="tns:Fields/tns:BoxOffice/tns:Value">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Box_Office</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:BoxOffice/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>

	<!-- Propagation_Priority -->
	<xsl:if test="tns:Fields/tns:PropagationPriority">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Propagation_Priority</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:PropagationPriority" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>	
	
	<!-- Auto_Import -->
	<xsl:if test="tns:Fields/tns:AutoImport">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Auto_Import</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="tns:Fields/tns:AutoImport" />
			</xsl:attribute>
		</App_Data>	
	</xsl:if>
	
	<!-- Auto_Deploy -->
	<xsl:if test="tns:Fields/tns:AutoDeploy">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Auto_Deploy</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="tns:Fields/tns:AutoDeploy" />
			</xsl:attribute>
		</App_Data>	
	</xsl:if>

	<!--  Auto_Delete -->
	<xsl:if test="tns:Fields/tns:AutoDelete">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Auto_Delete</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="tns:Fields/tns:AutoDelete" />
			</xsl:attribute>
		</App_Data>	
	</xsl:if>

	<!--  Billing_ID -->
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Billing_ID</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:BillingInfo/tns:Identifier/tns:Id" />
		</xsl:attribute>
	</App_Data>
	
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet LicensingWindowStartAttribute" />
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet LicensingWindowEndAttribute" />
	
	<!--  Preview_Period -->
	<xsl:if test="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Preview_Period</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:variable name="myValue" select="number(substring-before(tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration, ':')) * 3600 
							+ number(substring-before(substring-after(tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration, ':'), ':') * 60) 
							+ number(substring-after(substring-after(tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration, ':'), ':'))"/>
				<xsl:choose>
					<xsl:when test="not(string($myValue) castable as xs:integer) or number($myValue) &lt; 0 or contains(tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration, '-')">
					    <xsl:value-of select="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration" />
					</xsl:when>
					<xsl:otherwise>
					    <xsl:value-of select="$myValue" />
						</xsl:otherwise>
					</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!--  Home_Video_Window -->
	<xsl:if test="tns:Fields/tns:Rights/tns:HomeVideoWindow">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Home_Video_Window</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:HomeVideoWindow" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Display_As_New -->
	<xsl:if test="tns:Fields/tns:Rights/tns:NewReleaseWindow">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Display_As_New</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:NewReleaseWindow" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Display_As_Last_Chance -->
	<xsl:if test="tns:Fields/tns:Rights/tns:DisplayAsLastChance">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Display_As_Last_Chance</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:DisplayAsLastChance" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Maximum_Viewing_Length -->
	<xsl:if test="tns:Fields/tns:Rights/tns:MaxViewingLimit">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Maximum_Viewing_Length</xsl:attribute>
		<xsl:attribute name="Value">
			<xsl:choose>
				<xsl:when test="tns:Fields/tns:Rights/tns:MaxViewingLimit castable as xs:integer">
				    <xsl:value-of select="format-number(floor(number(tns:Fields/tns:Rights/tns:MaxViewingLimit) div 1440), '00')"/>:<xsl:value-of select="format-number( floor((number(tns:Fields/tns:Rights/tns:MaxViewingLimit) - ( floor(number(tns:Fields/tns:Rights/tns:MaxViewingLimit) div 1440 ) * 1440 ))  div 60), '00')"/>:<xsl:value-of select="format-number(number(tns:Fields/tns:Rights/tns:MaxViewingLimit) mod 60, '00')"/>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:value-of select="tns:Fields/tns:Rights/tns:MaxViewingLimit"/>
			    </xsl:otherwise>
		    </xsl:choose>
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Contract_Name -->
	<xsl:if test="tns:Fields/tns:Rights/tns:Contract/tns:Name">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Contract_Name</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:Contract/tns:Name" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!-- Suggested_Price -->
	<xsl:if test="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Suggested_Price</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Distributor_Royalty_Percent -->
	<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyPercent">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Distributor_Royalty_Percent</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyPercent" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Distributor_Royalty_Minimum -->
	<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyMinimum">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Distributor_Royalty_Minimum</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyMinimum" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Distributor_Royalty_Flat_Rate -->
	<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Distributor_Royalty_Flat_Rate</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyFlatRate" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Distributor_Name -->
	<xsl:if test="tns:Fields/tns:Distributor/tns:Name">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Distributor_Name</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:Distributor/tns:Name" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Studio_Royalty_Percent -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyPercent">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Studio_Royalty_Percent</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyPercent" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!-- Studio_Royalty_Minimum -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyMinimum">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Studio_Royalty_Minimum</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyMinimum" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	
	<!--  Studio_Royalty_Flat_Rate -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Studio_Royalty_Flat_Rate</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyFlatRate" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>

	<!--  Studio_Name -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Studio_Name</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!--  Studio_Code -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Code">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Studio_Code</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:Code" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Provider_QA_Contact -->
	<xsl:if test="tns:Fields/tns:ProviderQAContact">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Provider_QA_Contact</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:ProviderQAContact/tns:Value" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Programmer_Call_Letters -->
	<xsl:if test="tns:Fields/tns:TvId/tns:Network">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Programmer_Call_Letters</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TvId/tns:Network" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Recording_Artist -->
	<xsl:if test="tns:Fields/tns:TitleArtist">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Recording_Artist</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TitleArtist" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Song_Title -->
	<xsl:if test="tns:Fields/tns:SongTitle">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Song_Title</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:SongTitle" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- TSTV 3.2 fields -->
	<xsl:call-template name="title_tstv" />	
	
	<!--  Custom Field -->
	<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
	<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		
</xsl:template>

</xsl:stylesheet>
