<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="from/common.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'TRICK']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">
					<xsl:choose>
						<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">trickfile</xsl:when>
						<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</AMS>
			<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet BitRateAttribute" />
			</xsl:if>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFileSizeAttribute" />
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentChecksumAttribute" />
			<xsl:if test="tns:Fields/tns:Vendor/tns:Name">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet VendorNameAttribute" />
			</xsl:if>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Vendor_Product</xsl:attribute>
				<xsl:attribute name="Value">
				    <xsl:value-of select="tns:Fields/tns:Vendor/tns:Product" />
				</xsl:attribute>
			</App_Data>
			<xsl:if test="tns:Fields/tns:Vendor/tns:ForVersion">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">For_Version</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Vendor/tns:ForVersion" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Trick_Mode</xsl:attribute>
				<xsl:attribute name="Value">
				    <xsl:value-of select="tns:Fields/tns:TrickMode" />
				</xsl:attribute>
			</App_Data>
			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>