<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	version="1.0">
	
	<xsl:import href="from/mappedCustomFields.xsl" />
	<xsl:output method="xml" indent="yes"/>

	<!-- Unmapped Custom Fields section -->
	<xsl:template match="tns:Fields/tns:CustomFields-CL1_1">
		<xsl:apply-templates select="tns:CustomField" mode="unmapped" />
	</xsl:template>

	<!-- Mapped Custom Fields section -->
	<xsl:template match="tns:Fields/tns:CustomFields">
		<xsl:apply-templates select="tns:CustomField" mode="mapped" />
	</xsl:template>

	<!-- Unmapped Custom Field -->
	<xsl:template match="tns:CustomField" mode="unmapped">
		<xsl:element name="App_Data">
			<xsl:attribute name="App">
				<xsl:value-of select="../../tns:ApplicationInfo/tns:Name" />
			</xsl:attribute>
			<xsl:attribute name="Name">
				<xsl:value-of select="@name" />
			</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="@value" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

	<!-- Mapped Custom Field -->
	<xsl:template
		match="tns:CustomField[@name='TitleArtist'
								or @name = 'SongTitle'
								or @name = 'TitleLanguage'
								or @name = 'TitleLicenseWindowStartSec'
								or @name = 'TitleLicenseWindowEndSec'
								or @name = 'TitleRatingSec'
								or @name = 'TitlePriceSec'
								]"
		mode="mapped">
		<xsl:element name="App_Data">
			<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
			<xsl:attribute name="Name"><xsl:value-of select="@name" /></xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
				<xsl:when test="@name = 'Burn_Allowed'">
					<xsl:choose>
						<xsl:when test="@value = 'true'">Y</xsl:when>
						<xsl:when test="@value = 'false'">N</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
			    </xsl:when>
			    <xsl:otherwise>
			    	<xsl:value-of select="@value" />
			    </xsl:otherwise>
			    </xsl:choose>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
