<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">
<xsl:import href="from/package.xsl"/>
<xsl:import href="from/title.xsl"/>

<xsl:import href="from/movie.xsl"/>
<xsl:import href="from/preview.xsl"/>
<xsl:import href="from/movie_segment_group.xsl"/>
<xsl:import href="from/preview_segment_group.xsl"/>

<xsl:import href="from/boxcover.xsl"/>
<xsl:import href="from/poster.xsl"/>
<xsl:import href="from/trick.xsl"/>
<xsl:import href="from/encrypted.xsl"/>
<xsl:import href="from/barker.xsl"/>
<xsl:import href="from/display.xsl"/>

<xsl:template match="/">
	<ADI>
		<Metadata>
			<xsl:apply-templates select="tns:TTVSpec/tns:Group[@type = 'PACKAGE']" />
		</Metadata>
		<Asset>
			<Metadata>
				<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TITLE']" />
			</Metadata>

			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'DISPLAY']" />
			
			<xsl:call-template name="movies" />
			<xsl:call-template name="previews" />

			<xsl:call-template name="moviesegmentgroups" />
			<xsl:call-template name="previewsegmentgroups" />
			
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'BOXCOVER']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'POSTER']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TRICK']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'ENCRYPTED']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'BARKER']" />
		</Asset>
	</ADI>
</xsl:template>

</xsl:stylesheet>
