<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn xs">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>

<!-- Extra fields from OSVOD spec -->
<xsl:template name="title_osvod" >

	<!-- Package Usage -->
	<xsl:for-each select="tns:Fields/tns:OSVOD/tns:PackageUsages/tns:PackageUsage">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Package_Usage</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="." />
			</xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- PackageRef -->
	<xsl:for-each select="tns:Fields/tns:OSVOD/tns:PackageRefs/tns:PackageRef">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">PackageRef</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="." />
			</xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- Association ID -->
	<xsl:for-each select="tns:Fields/tns:OSVOD/tns:AssociationId">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Association_ID</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="." /> 
			</xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- On Disk Window Start -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:OnDiskWindowStart">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">On_Disk_Window_Start</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:OnDiskWindowStart" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- On Disk Window End -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:OnDiskWindowEnd">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">On_Disk_Window_End</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:OnDiskWindowEnd" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Min On Disk Duration -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:MinOnDiskDuration">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Min_On_Disk_Duration</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:MinOnDiskDuration" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Max On Disk Duration -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:MaxOnDiskDuration">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Max_On_Disk_Duration</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:MaxOnDiskDuration" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Max On Disk Duration After View -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:MaxOnDiskDurationAfterView">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Max_On_Disk_Duration_After_View</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:MaxOnDiskDurationAfterView" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Burn Allowed -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:BurnAllowed">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Burn_Allowed</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:BurnAllowed" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Max Burns Allowed -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:MaxBurnsAllowed">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Max_Burns_Allowed</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:MaxBurnsAllowed" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Max Concurrent Views Allowed -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:MaxConcurrentViewsAllowed">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Max_Concurrent_Views_Allowed</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:MaxConcurrentViewsAllowed" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Viewing Window -->
	<xsl:for-each select="tns:Fields/tns:OSVOD/tns:ViewingWindow">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Viewing_Window</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="." /> 
			</xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- Custom Sort Priority -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:CustomSortPriority">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Custom_Sort_Priority</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:CustomSortPriority" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Original Price -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:OriginalPrice">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Original_Price</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:OriginalPrice" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Business Class -->
	<xsl:if test="tns:Fields/tns:OSVOD/tns:BusinessClass">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Business_Class</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:OSVOD/tns:BusinessClass" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

</xsl:template>

</xsl:stylesheet>
