#!/bin/bash
# 
# Ed Silva
# ed.eduardo@ericsson.com
#
# Oct 23, 2010
#
############
############
##
## Functions
##
############
############

##
## DO NOT EDIT! THERE AREN'T ANY CONFIG PARAMETERS!
##

backup_failed_info()
{
	BAK_END=`date`
	warning "INFO: Host: ${M_HNAME} App: ${CB_APP} Backup Started: ${BAK_START} Backup Failed: ${BAK_END} "   

}
make_random ()
{
	tar_file_seed="$1"

	${CB_RM} -f ${CB_RANDOM}

	u_range=`tar tvf ${tar_file_seed} | wc -l `
	l_range=1000

	random_tmp=`od -N3 -An -i /dev/urandom | awk -v f="${l_range}" -v r="${u_range}" '{printf "%i\n", $1, f + r * $1 / 16777216}'`

	if [[ ${random_tmp} -lt ${u_range} ]];
	then
		${CB_ECHO}  ${random_tmp} > ${CB_RANDOM}
	else
		warning "WARNING: make_random out of range, generating: u_range - 300 "
		random_tmp = ${u_range} - 300
		${CB_ECHO} ${random_tmp} > ${CB_RANDOM}
	fi

}
warning()
{
	if [[ ! -f ${MAIL_WARN_TMP} ]];
	then
		touch ${MAIL_WARN_TMP}
	fi

	${CB_ECHO} $1 >> ${MAIL_WARN_TMP}
	
	return
}

adios()
{
	${CB_ECHO} $1 > ${MAIL_TMP}

	if [[ -s ${MAIL_WARN_TMP} ]];
	then
		cat ${MAIL_WARN_TMP} >>  ${MAIL_TMP}
	fi
	
	${MAIL_IT} -s ${M_HNAME} ${BAK_ADMIN} < ${MAIL_TMP}  
	${CB_RM} -f /tmp/*.tmp.${CB_PID}* 

	exit
}

list_files()
{
	if [[ -d ${BAK_CONF_DIR}/${CB_APP} ]]
	then
		cd ${BAK_CONF_DIR}/${CB_APP}

		for b in `${CB_CAT} $1 | ${CB_SORT} | ${CB_EGREP} -v '^$|#'`
		do
			dir_col=`${CB_ECHO} ${b} | ${CB_AWK} '{print NF}'`
			if [[ ${dir_col} -ne 1 ]];
			then
						
				warning "WARNING: list_files() corrupted entry ${b} in ${1} skipping"

			else	

				if [[ -f ${b} ]];
				then
					${CB_ECHO} ${b} >> ${TAR_TMP}
				fi
			fi
		done
	else
		backup_failed_info
		adios "FATAL ERROR: list_files() ${BAK_CONF_DIR}/${CB_APP} does not exist"
	fi
	
}

list_db_dir()
{
	if [[ -d ${BAK_CONF_DIR}/${CB_APP} ]]
	then
		cd ${BAK_CONF_DIR}/${CB_APP}

		for k in `${CB_CAT} $1| ${CB_SORT}`
		do
			if [[ -d ${k} ]];
			then
				cd ${k}

				for f in `${CB_LS} -1 | ${CB_EGREP} ${BAK_DATE}`
				do
					${CB_ECHO} "${k}/${f}" >> ${TAR_TMP}
				done
			fi
		done
	else
		backup_failed_info
		adios "FATAL ERROR: list_db_dir() ${BAK_CONF_DIR}/${CB_APP} does not exist"
	fi
	
}

list_dir()
{
	if [[ -d ${BAK_CONF_DIR}/${CB_APP} ]]
	then
		cd ${BAK_CONF_DIR}/${CB_APP}

		for e in `${CB_CAT} $1 | ${CB_SORT} | ${CB_EGREP} -v '#'|  ${CB_EGREP} ${DIR_FIELD}`
		do
			${CB_RM} -f ${TAR_TMP}.dir ${TAR_TMP}.pwd
			dir_col=`${CB_ECHO} ${e} |  ${CB_AWK} -F"${DIR_FIELD}" '{print NF}'`

			if [[ ${dir_col} -ne 2 ]];
			then
						
				backup_failed_info
				adios "FATAL ERROR: list_dir() missing directory directive in ${BAK_CONF_DIR}/${CB_APP}/${1}"

			fi	

			dir_type=`${CB_ECHO} ${e} | ${CB_AWK} -F"${DIR_FIELD}" '{print $1}'`
			dir_name=`${CB_ECHO} ${e} | ${CB_AWK} -F"${DIR_FIELD}" '{print $2}'`

			case "${dir_type}" in

        			"l"|"L")

					if [[ -d ${dir_name} ]];
					then

						cd ${dir_name}
						if [[ `ls -1 . | wc -l | ${CB_AWK} '{print $1}'` > 1 ]]; 
						then

							${CB_STAT} -c %F\;%n * | ${CB_AWK} -v dname="${dir_name}" -F';' '$1 == "regular empty file" || $1 == "regular file" || $1 == "symbolic link" {printf("%s/%s\n",dname,$2)}' >> ${TAR_TMP}

						else
							warning "WARNING: list_dir() directory ${dir_name} is empty...skipping"
						fi
							 
					else
							
						warning "WARNING: list_dir() directory ${dir_name} does not exist...skipping"

					fi
					;;

        			"r"|"R")

					if [[ -d "${dir_name}" ]];
					then
	
						${CB_ECHO} "${dir_name}" >> ${TAR_TMP}
					else

						warning "WARNING: list_dir() directory ${dir_name} does not exist...skipping"
					fi
                			;;

        			*)
					warning "WARNING: list_dir() unknown ${dir_type} directory directive in ${1} skipping"
                			;;
			esac
		done

	else
		backup_failed_info
		adios "FATAL ERROR: list_dir() ${BAK_CONF_DIR}/${CB_APP} does not exist"
	fi
	
}

check_san()
{
	case "${SAN}" in

		"" )
			adios "FATAL ERROR: check_san() SAN has not been configured"
			;;
		"/")
			adios "FATAL ERROR: check_san() SAN cannot be root directory"
			;;
		*)
		
			if [[ -d ${SAN} ]];
			then
				dir_name=`${CB_ECHO} "${SAN}" | ${CB_AWK} -F'/' '{print $NF}'`

				case "${dir_name}" in
			
					"."|"..")

						backup_failed_info
						adios "FATAL ERROR: check_san() ${dir_name} is not a valid dir name"
						;;
					*)

        					san_check=`${CB_DF} -P -T ${SAN}| ${CB_TAIL} -1`
        					san_check_type=`${CB_ECHO} ${san_check}| ${CB_AWK} '{print $2}'`

						case "${san_check_type}" in

						"nfs"|"cifs"|"ext3")

							return 1
							;;
						*)
							backup_failed_info
							adios "FATAL ERROR: check_san() ${san_check_type} filesystem is not NFS or CIFS"
							;;
						esac
				esac
		else
			backup_failed_info
			adios "FATAL ERROR: check_san() ${SAN} is not a directory"
		fi
	esac
}

#####
##### END of functions
#####
