#!/bin/bash
#
# This script will display the current configuration 
# of commonbackup.
#
#
# Ed Silva
# ed.eduardo@ericsson.com
#
# (c)2010 Ericsson
#
# Version 1.0 10-28-2010 initial code
#

cb_bin_dir="$(cd `dirname $0` && pwd)"
cb_cfg_dir=`echo ${cb_bin_dir} | /usr/bin/awk -F'/' '{for (i = 2; i != NF; i++) printf("/%s",$i)}'`

CONFIG_FILE="${cb_cfg_dir}/conf/commonbackup.cfg"
CB_FUNCTIONS="${cb_bin_dir}/cb_functions.sh"

for f in ${CONFIG_FILE} ${CB_FUNCTIONS}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "FATAL ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done
clear
date
echo "       SAN: ${SAN}"
echo "   M_UNAME: ${M_UNAME}"
echo "M_IFCONFIG: ${M_IFCONFIG}"
echo "    CB_APP: ${CB_APP}"
echo " "

