#!/bin/bash
# 
# Ed Silva
# ed.eduardo@ericsson.com
#
# (c)2010 Ericsson 
#
# Version 1.0 4-7-2010 initial code
# Version 1.1 4-21-2010 rename scripts
# Version 1.2 5-24-2010 remove commonplatform dependency
#			bug fixing of san_check and san_free.
# Version 1.3 5-27-2010 hard coded path for CMS
#			
# Version 1.4 5-28-2010 CB_APP logic changed it uses
#                       ${BAK_CONF_DIR}/<app>.
#			
# Version 1.5 5-29-2010 updated san_check();
#                       
# Version 1.6 5-30-2010 re-wrote san_check();
#
# Version 1.7 5-30-2010 added dir condition for
#
# Version 2.0 10-14-2010 initial code based off V1.7
#
# Version 2.00-01 10-21-2010 updates to list_dir dos2unix code.
#
# Version 2.00-10 10-22-2010 tar file is verified, add error dir.
#			     added variables to cb config file.
#
# Version 2.00-12 10-22-2010 disk space in bytes for fs_free and bak_size.
#			     added comments to config file.
#
# Version 2.00-14 11-04-2010 fix log and error files deletion.
#
# Version 2.00-15 11-04-2010  updated SPECS files for upgrades.
#
# Version 2.00-16 11-04-2010  update2 SPECS files for upgrades.
# Version 2.00-17 11-06-2010  update3 SPECS files for upgrades.
# Version 2.00-18 11-08-2010  update4 SPECS files for upgrades.
#

cb_bin_dir="$(cd `dirname $0` && pwd)"
cb_cfg_dir=`echo ${cb_bin_dir} | /usr/bin/awk -F'/' '{for (i = 2; i != NF; i++) printf("/%s",$i)}'`

CONFIG_FILE="${cb_cfg_dir}/conf/commonbackup.cfg"
CB_FUNCTIONS="${cb_bin_dir}/cb_functions.sh"

for f in ${CONFIG_FILE} ${CB_FUNCTIONS}
do
	if [[ -f ${f} ]];
	then
		. ${f}
	else
		echo " "
		echo "FATAL ERROR: ${f} does not exist"
		echo " "
		exit 1
	fi
done

############################################################
# 
# 
# Check for at least one argument...
# and a maximum of 12. The maximum can be 
# edited in commonbackup.cfg file, but must be at least "1"
#

if [[ $# -lt 1 || $# -gt ${MAX_ARGS} ]];
then
	if [ $# -lt 1 ];
	then
		adios "USAGE: $0 <data_list>"
	fi

	if [ $# -gt ${MAX_ARGS} ];
	then
		adios "$# exceedes maximum of ${MAX_ARGS} arguments"
	fi
	
	adios
fi

#
# Find and remove duplicate arguments...
# 

for a in `${CB_ECHO} $@` 
do
	${CB_ECHO} ${a} >> ${ARGS_TMP}
done

BAK_TYPE=`${CB_EGREP} TYPE_ ${ARGS_TMP}| $CB_AWK -F'_' '{print $2}'`

	if [ -s ${BAK_TYPE} ];
	then		
		backup_failed_info
		adios "ERROR: No backup type defined" 
	fi

#
# Saved clean list of arguments
#

my_uniq_args=`${CB_SORT} ${ARGS_TMP}| ${CB_EGREP} -v TYPE_ | ${CB_UNIQ}| ${CB_TR} -s '\n' ' ' `

############################################
#
# Verify by application config directory
# exist else we exit.
#

	if [[ ! -d ${BAK_CONF_DIR}/${CB_APP} ]];
        then
		backup_failed_info
                adios "ERROR: no ${BAK_CONF_DIR}/<app> exists"
        fi
#
# Check archives and SAN
# Directories
#

	for d in Mon Tue Wed Thu Fri Sat Sun
	do
		if [[ ! -d ${BAK_DIR}/${d} ]];
		then
			/bin/mkdir -p ${BAK_DIR}/${d}
			chmod 0755 ${BAK_DIR}/${d}
		fi
	done

#
# Is the SAN volume mounted?
#

	check_san

	if [[ $? -lt 1 ]];
	then		
		adios "ERROR: NO SAN VOLUME"
	fi
#
# Build backup list
# from the arguments passed
#

cd ${BAK_CONF_DIR}/${CB_APP}
${CB_RM} -f ${TAR_TMP}

#
# Check config files for CRLF
#

for l in `${CB_ECHO} ${my_uniq_args}`
do

	dos_file=""
	dos_file=`/usr/bin/file -F' ' ${l}  | ${CB_AWK} 'NF == 7 && $5 == "CRLF" {print $1}'`

	if [ ! -z ${dos_file} ];
	then
		/usr/bin/dos2unix -q -k ${dos_file}
		warning "WARNING: dos2unix converted ${dos_file} to UNIX ASCII format"
	fi
done

#
# Add /etc and /var/spool/cron /root/.ssh/ to the backup
#

${CB_ECHO} "/etc"  >> ${TAR_TMP}
${CB_ECHO} "/var/spool/cron/" >> ${TAR_TMP}
${CB_ECHO} "/root/.ssh/" >> ${TAR_TMP}



for l in `${CB_ECHO} ${my_uniq_args}`
do
	case "${l}" in

	"${CB_APP}_files.txt")
		list_files $l
		;;
	"${CB_APP}_directories.txt")
		list_dir $l
		;;
	"${CB_APP}_rman_arch.txt")
		list_db_dir $l
		;;
	"${CB_APP}_rman_full.txt")
		list_db_dir $l
		;;
	*)	
		;;
	esac

done

# 
# The name of the tar archive
#

VERIFY_TAR_LOG="/tmp/${M_HNAME}_${CB_APP}_${BAK_TYPE}_${BAK_DATE}_${M_HOUR}${M_MIN}.log"

#APPS_TAR_FILE="${M_HNAME}_${CB_APP}_${BAK_TYPE}_${BAK_DATE}_${M_HOUR}${M_MIN}.tar"
APPS_TAR_FILE="${M_HNAME}_${CB_APP}_${BAK_TYPE}_${BAK_DATE}_${M_HOUR}${M_MIN}.tgz"
BAK_ERROR="${BAK_ERROR_DIR}/${M_HNAME}_${CB_APP}_${BAK_TYPE}_${BAK_DATE}_${M_HOUR}${M_MIN}.err"

OLD_TAR_FILES="${M_HNAME}_${CB_APP}_${BAK_TYPE}_${BAK_DATE}"

#
# Get total size of backup
#

cd /

${CB_RM} -f  ${SIZE_TMP}

if [[ `${CB_WC} -l ${TAR_TMP} | ${CB_AWK} '{print $1}'` -gt 0 ]];
	then
		${CB_CAT} ${TAR_TMP} | ${CB_AWK} '{printf("/usr/bin/du -b -s \"%s\"\n",$0)}' >> ${DU_TMP}

		bak_size=`/bin/bash ${DU_TMP} | ${CB_AWK} '{ sum+= $1 } END { print sum }'`

		fs_free=`${CB_DF} -B 1 -P / | ${CB_TAIL} -1 | ${CB_AWK} '{print $4}'`
		let  half_bak_size=(${bak_size}/2)

		if [ ${bak_size} -gt 0 ];
		then

			if [ ${half_bak_size} -gt ${fs_free} ];
			then
				backup_failed_info
				adios "ERROR: not enough space for archives half_bak_size(bytes): ${half_bak_size} fs_free(bytes): ${fs_free}"
			fi
		else

			warning "INFO: Nothing to backup"
			adios "ERROR: bak_size:${bak_size} fs_free:${fs_free} half_bak_size:${half_bak_size}"

		fi
	else
		adios "INFO: Nothing to backup"
	fi
#
# Create TAR archive
#

cd /

${CB_CP} ${TAR_TMP} ${TAR_TMP}.cut

${CB_CAT} ${TAR_TMP}.cut | ${CB_CUT} -c2- >${TAR_TMP}

if [[ -f ${VERIFY_TAR_LOG} ]];
then
	${CB_RM} -f ${VERIFY_TAR_LOG}
fi

${M_TAR} ${BAK_DIR}${M_WDAY}/${APPS_TAR_FILE} -T ${TAR_TMP}
${V_TAR} ${BAK_DIR}${M_WDAY}/${APPS_TAR_FILE} >> ${VERIFY_TAR_LOG}

if [[ -s ${VERIFY_TAR_LOG} ]];
then
	cp -p ${VERIFY_TAR_LOG} ${BAK_ERROR}
	warning "WARNING: Some files failed verification please check ${BAK_ERROR}"

        ${CB_RM} -f ${VERIFY_TAR_LOG}
else
        ${CB_RM} -f ${VERIFY_TAR_LOG}
fi

san_free=`${CB_DF} -P ${SAN} | ${CB_TAIL} -1 | ${CB_AWK} '{print $4}'`
tar_size=`${CB_LS} -l --time-style=locale ${TAR_TMP}| ${CB_AWK} '{print $5}'`

	if [ ${san_free} -gt ${tar_size} ];
	then 
		${CB_CP} -p ${BAK_DIR}${M_WDAY}/${APPS_TAR_FILE} ${SAN}/${APPS_TAR_FILE}.${CB_PID}
		chmod 0644 ${SAN}/${APPS_TAR_FILE}.${CB_PID}

		tar_1=`${CB_LS} -l --time-style=locale ${BAK_DIR}${M_WDAY}/${APPS_TAR_FILE}| ${CB_AWK} '{print $5}'`
		tar_2=`${CB_LS} -l --time-style=locale ${SAN}/${APPS_TAR_FILE}.${CB_PID}| ${CB_AWK} '{print $5}'`

		if [ ${tar_1} -eq ${tar_2} ];
		then
			${CB_RM} -f ${BAK_DIR}${M_WDAY}/${APPS_TAR_FILE}
			${CB_RM} -f ${SAN}/${OLD_TAR_FILES}_????.tgz

			${CB_MV} ${SAN}/${APPS_TAR_FILE}.${CB_PID} ${SAN}/${APPS_TAR_FILE}
		else
			backup_failed_info
			adios "ERROR: copy to ${SAN} failed"
		fi
		
	else
		adios "ERROR: No space on SAN"
	fi

BAK_END=`date`

adios "INFO: Host: ${M_HNAME} App: ${CB_APP} Backup Started ${BAK_START} Backup completed: ${BAK_END}  "	

#####
##### END
#####
