/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.login;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import java.util.List;

public class LoginTest {
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "admin";
    private static final int WAIT_SECONDS = 30;
    private WebClient webClient;
    private String portalUrl;

    public LoginTest(String string) {
        this.portalUrl = "https://" + string + ":8443/portal/";
    }

    private void setLoginAlertHandler() {
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String string) {
                LoginTest.info(String.format("Alerts @ Page: %s, Alert: %s", page, string));
                if (string.toLowerCase().contains("fail")) {
                    LoginTest.info("Word \"fail\" present in the alert");
                    LoginTest.this.exit(1);
                }
            }
        });
    }

    private void setLogoutAlertHandler() {
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String string) {
                LoginTest.info(String.format("Alerts @ Page: %s, Alert: %s", page, string));
                if (!string.contains("Logged out successfully.")) {
                    LoginTest.info("Could not logout");
                    LoginTest.this.exit(1);
                }
            }
        });
    }

    private void submitLoginForm(HtmlPage htmlPage) throws Exception {
        String string = "//tbody/tr[1]/td[2]/input";
        String string2 = "//tbody/tr[2]/td[2]/input";
        String string3 = "//tbody/tr[3]/td[2]/button";
        HtmlTextInput htmlTextInput = (HtmlTextInput)htmlPage.getFirstByXPath(string);
        HtmlPasswordInput htmlPasswordInput = (HtmlPasswordInput)htmlPage.getFirstByXPath(string2);
        HtmlButton htmlButton = (HtmlButton)htmlPage.getFirstByXPath(string3);
        if (htmlTextInput == null) {
            LoginTest.info("User Name field not found");
            this.exit(1);
        }
        if (htmlPasswordInput == null) {
            LoginTest.info("Password field not found");
            this.exit(1);
        }
        if (htmlButton == null) {
            LoginTest.info("Login button not found");
            this.exit(1);
        }
        LoginTest.info("Login page obtained. Attempting login");
        htmlTextInput.setValueAttribute("admin");
        htmlPasswordInput.setValueAttribute("admin");
        htmlButton.click();
    }

    private HtmlButton findLogoutButton(HtmlPage htmlPage) {
        HtmlButton htmlButton = null;
        List list = htmlPage.getByXPath("//tbody/tr/td/button");
        if (list != null) {
            for (HtmlButton htmlButton2 : list) {
                if (!htmlButton2.asText().equals("Log Out")) continue;
                htmlButton = htmlButton2;
            }
        }
        return htmlButton;
    }

    private void test() throws Exception {
        this.webClient = new WebClient(BrowserVersion.INTERNET_EXPLORER_8);
        this.webClient.setUseInsecureSSL(true);
        this.setLoginAlertHandler();
        LoginTest.info("Connecting to: " + this.portalUrl);
        HtmlPage htmlPage = (HtmlPage)this.webClient.getPage(this.portalUrl);
        this.wait(30);
        this.submitLoginForm(htmlPage);
        this.wait(30);
        HtmlButton htmlButton = this.findLogoutButton(htmlPage);
        if (htmlButton == null) {
            LoginTest.info("Logout button not found");
            this.exit(1);
        }
        LoginTest.info("Attempting logout");
        this.setLogoutAlertHandler();
        htmlButton.click();
        this.wait(30);
    }

    private void wait(int n) {
        LoginTest.info("Waiting " + n + " seconds for JavaScript to finish");
        this.webClient.waitForBackgroundJavaScript((long)(n * 1000));
    }

    private void exit(int n) {
        if (this.webClient != null) {
            this.webClient.closeAllWindows();
        }
        if (n == 0) {
            LoginTest.info("Exiting normally (status code = 0)");
        } else {
            LoginTest.info("Exiting abnormally (sttaus code = " + n + ")");
        }
        System.exit(n);
    }

    private static void info(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: LoginTest <host>");
            System.exit(1);
        }
        LoginTest loginTest = new LoginTest(stringArray[0]);
        try {
            loginTest.test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loginTest.exit(1);
        }
        loginTest.exit(0);
    }
}

