/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.vmware;

import com.ericsson.automation.vmware.FileUtil;
import com.ericsson.automation.vmware.SOAPUtil;
import com.ericsson.automation.vmware.SSLUtil;
import com.ericsson.automation.vmware.VMManager;
import com.ericsson.automation.vmware.VimConnection;
import com.vmware.vim25.ManagedObjectReference;
import java.util.Properties;
import javax.xml.ws.soap.SOAPFaultException;

public class PowerMain {
    private VimConnection conn = null;

    private boolean connect(Properties properties) {
        try {
            this.conn = new VimConnection(properties.getProperty("host"));
            this.conn.setUserName(properties.getProperty("user"));
            this.conn.setPassword(properties.getProperty("password"));
            this.conn.connect();
            return true;
        }
        catch (SOAPFaultException sOAPFaultException) {
            SOAPUtil.printSoapFault(sOAPFaultException);
            return false;
        }
        catch (Exception exception) {
            System.out.println("Could not connect");
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void power(String string, String string2) {
        try {
            VMManager vMManager = this.conn.getVMManager();
            ManagedObjectReference managedObjectReference = vMManager.findVM(string);
            if (managedObjectReference == null) {
                System.out.println("Could not find VM " + string);
                return;
            }
            if ("ON".equalsIgnoreCase(string2)) {
                vMManager.powerOnVM(managedObjectReference);
            } else if ("OFF".equalsIgnoreCase(string2)) {
                vMManager.powerOffVM(managedObjectReference);
            } else {
                System.out.println("ERROR: Invalid action: " + string2);
            }
        }
        catch (SOAPFaultException sOAPFaultException) {
            SOAPUtil.printSoapFault(sOAPFaultException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.conn.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) {
        String string;
        String string2;
        String string3 = "config.properties";
        if (stringArray.length == 3) {
            string3 = stringArray[0];
            string2 = stringArray[1];
            string = stringArray[2];
        } else if (stringArray.length == 2) {
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            PowerMain.printHelp();
            return;
        }
        SSLUtil.trustAll();
        PowerMain powerMain = new PowerMain();
        Properties properties = FileUtil.readProperties(string3);
        if (properties == null) {
            return;
        }
        if (!powerMain.connect(properties)) {
            return;
        }
        powerMain.power(string2, string);
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("    PowerMain [<configFile>] <VMName> <action>");
        System.out.println("where");
        System.out.println("    <configFile>     - Optional configuration file name");
        System.out.println("                       Default value is config.properties in current folder");
        System.out.println("    <VMName>         - Name of a virtual machine");
        System.out.println("    <action>         - ON | OFF");
    }
}

