/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.vmware;

import com.ericsson.automation.vmware.VimConnection;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VirtualMachineSnapshotTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SnapshotHelper {
    private VimConnection connection;

    public SnapshotHelper(VimConnection vimConnection) {
        this.connection = vimConnection;
    }

    ManagedObjectReference getSnapshotReference(ManagedObjectReference managedObjectReference, String string) throws Exception {
        VirtualMachineSnapshotInfo virtualMachineSnapshotInfo = (VirtualMachineSnapshotInfo)this.getEntityProps(managedObjectReference, new String[]{"snapshot"}).get("snapshot");
        ManagedObjectReference managedObjectReference2 = null;
        if (virtualMachineSnapshotInfo != null) {
            List list = virtualMachineSnapshotInfo.getRootSnapshotList();
            managedObjectReference2 = this.traverseSnapshotInTree(list, string, false);
        }
        return managedObjectReference2;
    }

    private Map<String, Object> getEntityProps(ManagedObjectReference managedObjectReference, String[] stringArray) throws Exception {
        VimPortType vimPortType = this.connection.getVimPort();
        ServiceContent serviceContent = this.connection.getServiceContent();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.valueOf(false));
        propertySpec.setType(managedObjectReference.getType());
        propertySpec.getPathSet().addAll(Arrays.asList(stringArray));
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        RetrieveResult retrieveResult = vimPortType.retrievePropertiesEx(serviceContent.getPropertyCollector(), arrayList, new RetrieveOptions());
        ArrayList arrayList2 = new ArrayList();
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList2.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = vimPortType.continueRetrievePropertiesEx(serviceContent.getPropertyCollector(), string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList2.addAll(retrieveResult.getObjects());
        }
        for (ObjectContent objectContent : arrayList2) {
            List list = objectContent.getPropSet();
            if (list == null) continue;
            for (DynamicProperty dynamicProperty : list) {
                hashMap.put(dynamicProperty.getName(), dynamicProperty.getVal());
            }
        }
        return hashMap;
    }

    private ManagedObjectReference traverseSnapshotInTree(List<VirtualMachineSnapshotTree> list, String string, boolean bl) {
        ManagedObjectReference managedObjectReference = null;
        if (list == null) {
            return managedObjectReference;
        }
        for (VirtualMachineSnapshotTree virtualMachineSnapshotTree : list) {
            List list2;
            if (bl) {
                System.out.println("Snapshot Name : " + virtualMachineSnapshotTree.getName());
            }
            if (string != null && virtualMachineSnapshotTree.getName().equalsIgnoreCase(string)) {
                return virtualMachineSnapshotTree.getSnapshot();
            }
            List list3 = list2 = virtualMachineSnapshotTree.getChildSnapshotList();
            managedObjectReference = this.traverseSnapshotInTree(list3, string, bl);
        }
        return managedObjectReference;
    }
}

