/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.vmware;

import com.ericsson.automation.vmware.VimConnection;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VMHelper {
    private VimConnection connection;

    public VMHelper(VimConnection vimConnection) {
        this.connection = vimConnection;
    }

    Map<String, ManagedObjectReference> getRefsInContainerByType(ManagedObjectReference managedObjectReference, String string) throws Exception {
        ServiceContent serviceContent = this.connection.getServiceContent();
        VimPortType vimPortType = this.connection.getVimPort();
        ManagedObjectReference managedObjectReference2 = serviceContent.getViewManager();
        ManagedObjectReference managedObjectReference3 = vimPortType.createContainerView(managedObjectReference2, managedObjectReference, Arrays.asList(string), true);
        HashMap<String, ManagedObjectReference> hashMap = new HashMap<String, ManagedObjectReference>();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType(string);
        propertySpec.getPathSet().add("name");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("view");
        traversalSpec.setPath("view");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.setType("ContainerView");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference3);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        RetrieveResult retrieveResult = vimPortType.retrievePropertiesEx(serviceContent.getPropertyCollector(), arrayList, new RetrieveOptions());
        ArrayList arrayList2 = new ArrayList();
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList2.addAll(retrieveResult.getObjects());
        }
        String string2 = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string2 = retrieveResult.getToken();
        }
        while (string2 != null && !string2.isEmpty()) {
            retrieveResult = vimPortType.continueRetrievePropertiesEx(serviceContent.getPropertyCollector(), string2);
            string2 = null;
            if (retrieveResult == null) continue;
            string2 = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList2.addAll(retrieveResult.getObjects());
        }
        for (ObjectContent objectContent : arrayList2) {
            ManagedObjectReference managedObjectReference4 = objectContent.getObj();
            String string3 = null;
            List list = objectContent.getPropSet();
            if (list != null) {
                for (DynamicProperty dynamicProperty : list) {
                    string3 = (String)dynamicProperty.getVal();
                }
            }
            hashMap.put(string3, managedObjectReference4);
        }
        return hashMap;
    }
}

