/*
 * Decompiled with CFR 0.152.
 */
package memory.namingPersistence;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import memory.namingPersistence.NamingContextBase;
import memory.namingPersistence.NamingContextBaseRef;
import namingPersistence.NamingContext;
import namingPersistence.NamingContextHome;
import namingPersistence.NamingContextRef;
import namingPersistence.NamingObjectRef;
import namingPersistence.ProxyNamingContextRef;
import org.omg.CORBA.LocalObject;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.NotFoundException;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;

public class NamingContextHomeBase
extends LocalObject
implements NamingContextHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
            throw new NotFound();
        }
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public NamingContextBase _create(String componentName, NamingContextRef[] nc_children, NamingObjectRef[] no_children, ProxyNamingContextRef[] pnc_children) {
        NamingContextBase obj = (NamingContextBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:namingPersistence/NamingContextBase:1.0");
        this.register_type_incarnation(obj);
        obj.componentName(componentName);
        obj.nc_children(nc_children);
        obj.no_children(no_children);
        obj.pnc_children(pnc_children);
        return obj;
    }

    public NamingContextBase _create() {
        NamingContextBase obj = (NamingContextBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:namingPersistence/NamingContextBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public NamingContextBaseRef _create(String componentName, NamingContextRef[] nc_children, NamingObjectRef[] no_children, ProxyNamingContextRef[] pnc_children, YieldRef yr) {
        NamingContextBase obj = this._create(componentName, nc_children, no_children, pnc_children);
        return new NamingContextBaseRef(obj.get_pid(), this._catalog);
    }

    public NamingContextBaseRef _create(YieldRef yr) {
        NamingContextBase obj = this._create();
        return new NamingContextBaseRef(obj.get_pid(), this._catalog);
    }

    public NamingContext create(String componentName, NamingContextRef[] nc_children, NamingObjectRef[] no_children, ProxyNamingContextRef[] pnc_children) {
        NamingContextBase obj = (NamingContextBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:namingPersistence/NamingContextBase:1.0");
        this.register_type_incarnation(obj);
        obj.componentName(componentName);
        obj.nc_children(nc_children);
        obj.no_children(no_children);
        obj.pnc_children(pnc_children);
        return obj;
    }

    public NamingContext find_by_componentName(String componentName) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                NamingContext obj = (NamingContext)it.next();
                String _tmp_componentName = obj.componentName();
                if (!componentName.equals(_tmp_componentName)) continue;
                NamingContext namingContext = obj;
                return namingContext;
            }
        }
        throw new NotFound();
    }

    public NamingContextRef find_ref_by_componentName(String componentName) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                NamingContext obj = (NamingContext)it.next();
                String _tmp_componentName = obj.componentName();
                if (!componentName.equals(_tmp_componentName)) continue;
                NamingContextBaseRef namingContextBaseRef = new NamingContextBaseRef(obj.get_short_pid(), this);
                return namingContextBaseRef;
            }
        }
        return null;
    }

    public Object[] get_incarnations() {
        return this._incarnations.toArray();
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new NamingContextBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((MemoryCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((MemoryCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

