/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ns.util;

import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.openorb.util.ExceptionTool;

public class NamingUtils {
    private static final NameComponent[] EMPTY_NAME = new NameComponent[0];

    public static void deepBind(NamingContext context, String name, Object obj) throws InvalidName, NotFound, CannotProceed, AlreadyBound {
        NamingUtils.deepBind(context, NamingUtils.to_name(name), obj);
    }

    public static void deepBind(NamingContext context, NameComponent[] name, Object obj) throws InvalidName, NotFound, CannotProceed, AlreadyBound {
        NameComponent[] ctxName = new NameComponent[name.length - 1];
        System.arraycopy(name, 0, ctxName, 0, ctxName.length);
        NamingContext sub = NamingUtils.resolveOrCreateContext(context, ctxName);
        sub.bind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    public static void deepRebind(NamingContext context, String name, Object obj) throws InvalidName, NotFound, CannotProceed {
        NamingUtils.deepRebind(context, NamingUtils.to_name(name), obj);
    }

    public static void deepRebind(NamingContext context, NameComponent[] name, Object obj) throws InvalidName, NotFound, CannotProceed {
        NameComponent[] ctxName = new NameComponent[name.length - 1];
        System.arraycopy(name, 0, ctxName, 0, ctxName.length);
        NamingContext sub = NamingUtils.resolveOrCreateContext(context, ctxName);
        sub.rebind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    /*
     * Unable to fully structure code
     */
    public static NamingContext resolveOrCreateContext(NamingContext context, NameComponent[] name) throws InvalidName, NotFound, CannotProceed {
        block11: {
            try {
                obj = context.resolve(name);
                break block11;
            }
            catch (NotFound ex) {
                switch (ex.why.value()) {
                    case 1: 
                    case 2: {
                        throw ex;
                    }
                }
                bname = new NameComponent[name.length - ex.rest_of_name.length];
                System.arraycopy(name, 0, bname, 0, bname.length);
                base = context;
                if (bname.length > 0) {
                    base = NamingContextHelper.narrow((Object)context.resolve(bname));
                }
                i = 0;
                ** while (i < ex.rest_of_name.length)
            }
lbl-1000:
            // 1 sources

            {
                next = new NameComponent[]{ex.rest_of_name[i]};
                try {
                    base = base.bind_new_context(next);
                }
                catch (AlreadyBound ex1) {
                    base = NamingContextHelper.narrow((Object)base.resolve(next));
                }
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            return base;
        }
        try {
            return NamingContextHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            throw (NotFound)ExceptionTool.initCause((UserException)new NotFound(NotFoundReason.not_context, new NameComponent[]{name[name.length - 1]}), (Throwable)ex);
        }
    }

    public static NameComponent[] to_name(String sn) throws InvalidName {
        if (sn.length() == 0) {
            throw new InvalidName();
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        boolean id = true;
        StringBuffer buf = null;
        int i = 0;
        while (i < sn.length()) {
            switch (sn.charAt(i)) {
                case '\\': {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(sn.substring(start, i));
                    start = ++i;
                    break;
                }
                case '/': {
                    if (buf != null) {
                        list.add(buf.append(sn.substring(start, i)).toString());
                    } else {
                        list.add(sn.substring(start, i));
                    }
                    if (id) {
                        if (i == start && buf == null) {
                            throw new InvalidName();
                        }
                        list.add("");
                    } else {
                        id = true;
                    }
                    buf = null;
                    start = i + 1;
                    break;
                }
                case '.': {
                    if (!id) {
                        throw new InvalidName();
                    }
                    if (buf != null) {
                        list.add(buf.append(sn.substring(start, i)).toString());
                        buf = null;
                    } else {
                        list.add(sn.substring(start, i));
                    }
                    id = false;
                    start = i + 1;
                }
            }
            ++i;
        }
        if (buf != null) {
            list.add(buf.append(sn.substring(start)).toString());
        } else {
            list.add(sn.substring(start));
        }
        if (id) {
            if (start == sn.length() && buf == null) {
                throw new InvalidName();
            }
            list.add("");
        }
        NameComponent[] name = new NameComponent[list.size() / 2];
        Iterator itt = ((AbstractList)list).iterator();
        int i2 = 0;
        while (i2 < list.size()) {
            name[i2 / 2] = new NameComponent((String)itt.next(), (String)itt.next());
            i2 += 2;
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    public static String to_string(NameComponent[] n) throws InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        buf = new StringBuffer();
        i = 0;
        while (i < n.length) {
            block13: {
                block12: {
                    if (n[i].id != null && n[i].id.length() != 0) break block12;
                    buf.append('.');
                    if (n[i].kind != null && n[i].kind.length() != 0) ** GOTO lbl34
                    buf.append('/');
                    break block13;
                }
                start = 0;
                j = 0;
                while (j < n[i].id.length()) {
                    switch (n[i].id.charAt(j)) {
                        case '.': 
                        case '/': 
                        case '\\': {
                            buf.append(n[i].id.substring(start, j));
                            buf.append('\\');
                            start = j;
                        }
                    }
                    ++j;
                }
                buf.append(n[i].id.substring(start));
                if (n[i].kind == null || n[i].kind.length() == 0) {
                    buf.append('/');
                } else {
                    buf.append('.');
lbl34:
                    // 2 sources

                    start = 0;
                    j = 0;
                    while (j < n[i].kind.length()) {
                        switch (n[i].kind.charAt(j)) {
                            case '.': 
                            case '/': 
                            case '\\': {
                                buf.append(n[i].kind.substring(start, j));
                                buf.append('\\');
                                start = j;
                            }
                        }
                        ++j;
                    }
                    buf.append(n[i].kind.substring(start));
                    buf.append('/');
                }
            }
            ++i;
        }
        return buf.substring(0, buf.length() - 1);
    }

    public static String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (!org.openorb.util.NamingUtils.checkAddress((String)addr)) {
            throw new InvalidAddress();
        }
        NamingUtils.to_name(sn);
        String url = null;
        try {
            url = "corbaname:" + addr + "#" + org.openorb.util.NamingUtils.encodeRFC2396((String)sn);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        return url;
    }

    public static NameComponent[] parent(NameComponent[] name) {
        if (name.length <= 1) {
            return EMPTY_NAME;
        }
        NameComponent[] ret = new NameComponent[name.length - 1];
        System.arraycopy(name, 0, ret, 0, ret.length);
        return ret;
    }

    public static String parent(String name) {
        try {
            return NamingUtils.to_string(NamingUtils.parent(NamingUtils.to_name(name)));
        }
        catch (Exception ex) {
            return "";
        }
    }
}

