/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ns.examples.jndi;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class Client {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: Client <NamingService URL>");
            System.exit(-1);
        }
        try {
            Properties props = new Properties();
            ((Hashtable)props).put("java.naming.provider.url", args[0]);
            ((Hashtable)props).put("java.naming.factory.initial", "org.openorb.ns.jndi.CtxFactory");
            InitialContext ctx = new InitialContext(props);
            System.out.println("Creating sub-contexts...");
            Context subctx = ctx.createSubcontext("JNDIClient");
            subctx.createSubcontext("1");
            subctx.createSubcontext("2");
            subctx.createSubcontext("3");
            subctx.createSubcontext("4");
            subctx.createSubcontext("5");
            System.out.println("Listing the contents of the sub-context JNDIClient again...");
            NamingEnumeration<Binding> ne = ctx.listBindings("JNDIClient");
            while (ne.hasMore()) {
                Binding b = ne.next();
                System.out.println("\t" + b);
            }
            System.out.println("Leaving!");
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}

