/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ns.test;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.openorb.ns.util.NamingUtils;
import org.openorb.tns.MapNamingContext;

public class NamingTest
extends TestCase {
    private ORB m_orb;
    private POA m_root_poa;
    static /* synthetic */ Class class$org$openorb$ns$test$NamingTest;

    public NamingTest(String name) {
        super(name);
        String[] args = new String[]{};
        this.m_orb = ORB.init((String[])args, null);
    }

    protected void setUp() {
        try {
            this.m_root_poa = (POA)this.m_orb.resolve_initial_references("RootPOA");
            this.m_root_poa.the_POAManager().activate();
        }
        catch (UserException ex) {
            Assert.fail((String)("exception during setup:" + ex.toString()));
        }
    }

    protected void tearDown() {
    }

    private static boolean compareNames(NameComponent[] nc1, NameComponent[] nc2) {
        if (nc1.length != nc2.length) {
            return false;
        }
        int i = 0;
        while (i < nc1.length) {
            if (!nc1[i].id.equals(nc2[i].id) || !nc1[i].kind.equals(nc2[i].kind)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void testNameManipulation() throws InvalidName {
        String debug = "Empty name";
        NameComponent[] n = new NameComponent[]{new NameComponent("", "")};
        String s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)".");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        debug = "id only";
        n = new NameComponent[]{new NameComponent("hello", "")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)"hello");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        debug = "kind only";
        n = new NameComponent[]{new NameComponent("", "world")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)".world");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        debug = "both";
        n = new NameComponent[]{new NameComponent("hello", "world")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)"hello.world");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        debug = "Multiple elements...";
        n = new NameComponent[]{new NameComponent("", ""), new NameComponent("hello", ""), new NameComponent("", "world"), new NameComponent("hello", "world")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)"./hello/.world/hello.world");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        debug = "names needing escaping";
        n = new NameComponent[]{new NameComponent(".", "")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)"\\.");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        n = new NameComponent[]{new NameComponent("/", "")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)"\\/");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        n = new NameComponent[]{new NameComponent("\\", "")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)"\\\\");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        n = new NameComponent[]{new NameComponent("\\\\\\.../\\.", "/.//.\\"), new NameComponent("m.o.r.e.", "//slashy\\\\")};
        s = NamingUtils.to_string((NameComponent[])n);
        Assert.assertEquals((String)debug, (String)s, (String)"\\\\\\\\\\\\\\.\\.\\.\\/\\\\\\..\\/\\.\\/\\/\\.\\\\/m\\.o\\.r\\.e\\..\\/\\/slashy\\\\\\\\");
        Assert.assertTrue((String)debug, (boolean)NamingTest.compareNames(n, NamingUtils.to_name((String)s)));
        s = "";
        try {
            NamingUtils.to_name((String)s);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (InvalidName ex) {
            // empty catch block
        }
        s = "..";
        try {
            NamingUtils.to_name((String)s);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (InvalidName ex) {
            // empty catch block
        }
        s = "hello.world/";
        try {
            NamingUtils.to_name((String)s);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (InvalidName ex) {
            // empty catch block
        }
        s = "I.want.blood";
        try {
            NamingUtils.to_name((String)s);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (InvalidName ex) {
            // empty catch block
        }
    }

    public void testTransientNamingService() throws UserException {
        MapNamingContext map = new MapNamingContext(this.m_orb, null, null);
        NamingContextExt ctxt = map.getRootCtxt();
        map.put((java.lang.Object)"empty", null);
        map.put((java.lang.Object)"submap.context/recurse", (java.lang.Object)ctxt);
        map.put((java.lang.Object)"recurse", (java.lang.Object)ctxt);
        Object res = null;
        Object sub = null;
        BindingListHolder bl = new BindingListHolder();
        BindingIteratorHolder bi = new BindingIteratorHolder();
        ctxt.list(1, bl, bi);
        Assert.assertTrue((bl.value.length == 1 ? 1 : 0) != 0);
        if (bi.value != null) {
            BindingHolder bh = new BindingHolder();
            while (bi.value.next_one(bh)) {
            }
            bi.value.destroy();
        }
        NameComponent[] n = new NameComponent[]{new NameComponent("empty", "")};
        res = ctxt.resolve(n);
        Assert.assertNull((java.lang.Object)res);
        n = new NameComponent[]{new NameComponent("recurse", "")};
        res = ctxt.resolve(n);
        Assert.assertTrue((boolean)res._is_equivalent((Object)ctxt));
        sub = null;
        n[0] = new NameComponent("submap", "context");
        sub = ctxt.resolve(n);
        Assert.assertTrue((!sub._is_equivalent((Object)ctxt) ? 1 : 0) != 0);
        res = null;
        n[0] = new NameComponent("recurse", "");
        res = NamingContextHelper.narrow((Object)sub).resolve(n);
        Assert.assertTrue((boolean)res._is_equivalent((Object)ctxt));
        n = new NameComponent[]{new NameComponent("submap", "context"), new NameComponent("recurse", "")};
        res = ctxt.resolve(n);
        Assert.assertTrue((boolean)res._is_equivalent((Object)ctxt));
        sub = null;
        n[0] = new NameComponent("recurse", "");
        n[1] = new NameComponent("submap", "context");
        sub = ctxt.resolve(n);
        Assert.assertTrue((!sub._is_equivalent((Object)ctxt) ? 1 : 0) != 0);
        sub = null;
        n[0] = new NameComponent("recurse", "");
        n[1] = new NameComponent("nonexist", "");
        try {
            sub = ctxt.resolve(n);
            Assert.fail((String)"Able to resolve nonexistent context");
        }
        catch (NotFound ex) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(class$org$openorb$ns$test$NamingTest == null ? (class$org$openorb$ns$test$NamingTest = NamingTest.class$("org.openorb.ns.test.NamingTest")) : class$org$openorb$ns$test$NamingTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

