/*
 * Decompiled with CFR 0.152.
 */
package file.org.openorb.notify.persistence;

import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.openorb.notify.persistence.ConsumerAdminRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.file.FileCatalog;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PIDFactory;
import org.openorb.pss.connector.file.PersistentObjectHome;
import org.openorb.pss.connector.file.PersistentRef;

public class ConsumerAdminBaseRef
implements ConsumerAdminRef,
PersistentRef {
    private PID _pid;
    private StorageHomeBase _home_base;

    public ConsumerAdminBaseRef() {
    }

    public ConsumerAdminBaseRef(byte[] pid, CatalogBase c) {
        this._pid = PIDFactory.pid_byte_to_pid((byte[])pid);
        this._home_base = ((FileCatalog)c).find_home_base(this._pid);
    }

    public ConsumerAdminBaseRef(byte[] short_pid, StorageHomeBase h) {
        this._home_base = h;
        this._pid = PIDFactory.short_pid_to_pid((byte[])short_pid, (PID)((PersistentObjectHome)this._home_base).getPID());
    }

    public StorageObject deref() {
        return ((PersistentObjectHome)this._home_base).deref(this._pid);
    }

    public void destroy_object() {
        try {
            ((PersistentObjectHome)this._home_base).remove_storage_type(this._pid);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public boolean object_exists() {
        return ((PersistentObjectHome)this._home_base).is_stored(this._pid);
    }

    public byte[] get_pid() {
        return this._pid.value();
    }

    public byte[] get_short_pid() {
        return this._pid.short_value();
    }

    public StorageHomeBase get_storage_home() {
        return this._home_base;
    }

    public void setPersistentLinks(StorageHomeBase home_base, PID pid) {
        this._home_base = home_base;
        this._pid = pid;
    }

    public void update(byte[] pid) {
        this._pid = PIDFactory.pid_byte_to_pid((byte[])pid);
    }
}

