/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import org.apache.avalon.framework.logger.Logger;
import org.openorb.notify.ThreadManagement;

public abstract class NotifyThread
implements ThreadManagement,
Runnable {
    private Thread m_thread;
    private final String m_id;
    protected final Object m_stateLock = new byte[0];
    private boolean m_isRunning;
    private boolean m_finishWork;
    private final Logger m_logger;

    public NotifyThread(String id, Logger logger) {
        this.m_id = id;
        this.m_logger = logger.getChildLogger(id);
    }

    protected boolean isRunning() {
        Object object = this.m_stateLock;
        synchronized (object) {
            boolean bl = this.m_isRunning;
            return bl;
        }
    }

    protected void setRunning(boolean value) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_isRunning = value;
        }
    }

    protected boolean shouldFinishWork() {
        Object object = this.m_stateLock;
        synchronized (object) {
            boolean bl = this.m_finishWork;
            return bl;
        }
    }

    public void startThread() {
        this.getLogger().debug("Started.");
        this.setRunning(true);
        this.m_thread = new Thread((Runnable)this, this.m_id);
        this.m_thread.start();
    }

    public void resumeThread() {
        this.getLogger().debug("Resumed.");
        this.notifyAll();
    }

    public void suspendThread() {
        this.getLogger().debug("Suspended.");
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopThread() {
        this.getLogger().debug("Stopped.");
        this.m_thread = null;
        this.setRunning(false);
    }

    public void finishWorkAndStopThread() {
        this.getLogger().debug("Pending work finished and stopped.");
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_finishWork = true;
        }
    }

    public final Logger getLogger() {
        return this.m_logger;
    }

    public final String toString() {
        return this.m_id;
    }

    public abstract void run();
}

