/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CosNotification.Property;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public class PropertiesRepository
implements Cloneable {
    private Hashtable m_props = new Hashtable();

    public PropertiesRepository(Property[] qos, Property[] admin) {
        this.storeProperties(qos);
        this.storeProperties(admin);
    }

    public PropertiesRepository(Property[] qos) {
        this.storeProperties(qos);
    }

    public PropertiesRepository() {
    }

    public void setProperty(Object key, Object value) {
        this.m_props.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.m_props.get(key);
    }

    public boolean isConnectionReliable() {
        return (Short)this.m_props.get("ConnectionReliability") == 1;
    }

    public boolean isEventReliable() {
        return (Short)this.m_props.get("EventReliability") == 1;
    }

    public int getMaxQueueLength() {
        return (Integer)this.m_props.get("MaxQueueLength");
    }

    public int getMaxConsumers() {
        return (Integer)this.m_props.get("MaxConsumers");
    }

    public int getMaxSuppliers() {
        return (Integer)this.m_props.get("MaxSuppliers");
    }

    public boolean isRejectNewEvents() {
        return (Boolean)this.m_props.get("RejectNewEvents");
    }

    public short getPriority() {
        return (Short)this.m_props.get("Priority");
    }

    public UtcT getStartTime() {
        return (UtcT)this.m_props.get("StartTime");
    }

    public UtcT getStopTime() {
        return (UtcT)this.m_props.get("StopTime");
    }

    public long getTimeout() {
        return (Long)this.m_props.get("Timeout");
    }

    public boolean isStartTimeSupported() {
        return (Boolean)this.m_props.get("StartTimeSupported");
    }

    public boolean isStopTimeSupported() {
        return (Boolean)this.m_props.get("StopTimeSupported");
    }

    public int getMaxEventsPerConsumer() {
        return (Integer)this.m_props.get("MaxEventsPerConsumer");
    }

    public short getOrderPolicy() {
        return (Short)this.m_props.get("OrderPolicy");
    }

    public short getDiscardPolicy() {
        return (Short)this.m_props.get("DiscardPolicy");
    }

    public long getPacingInterval() {
        return (Long)this.m_props.get("PacingInterval");
    }

    public int getMaximumBatchSize() {
        return (Integer)this.m_props.get("MaximumBatchSize");
    }

    public boolean isQueueMaxPerformance() {
        Integer policy = (Integer)this.m_props.get("EventQueuesPolicy");
        return policy == 0;
    }

    public void storeProperties(Property[] props) {
        int i = 0;
        while (i < props.length) {
            String name = props[i].name;
            Any value = props[i].value;
            if (name.equals("MaxQueueLength")) {
                this.m_props.put("MaxQueueLength", new Integer(value.extract_long()));
            }
            if (name.equals("MaxConsumers")) {
                this.m_props.put("MaxConsumers", new Integer(value.extract_long()));
            }
            if (name.equals("MaxSuppliers")) {
                this.m_props.put("MaxSuppliers", new Integer(value.extract_long()));
            }
            if (name.equals("RejectNewEvents")) {
                this.m_props.put("RejectNewEvents", value.extract_boolean() ? Boolean.TRUE : Boolean.FALSE);
            }
            if (name.equals("EventReliability")) {
                this.m_props.put("EventReliability", new Short(value.extract_short()));
            }
            if (name.equals("ConnectionReliability")) {
                this.m_props.put("ConnectionReliability", new Short(value.extract_short()));
            }
            if (name.equals("Priority")) {
                this.m_props.put("Priority", new Short(value.extract_short()));
            }
            if (name.equals("StartTime")) {
                this.m_props.put("StartTime", UtcTHelper.extract(value));
            }
            if (name.equals("StopTime")) {
                this.m_props.put("StopTime", UtcTHelper.extract(value));
            }
            if (name.equals("Timeout")) {
                this.m_props.put("Timeout", new Long(TimeTHelper.extract(value)));
            }
            if (name.equals("StartTimeSupported")) {
                this.m_props.put("StartTimeSupported", value.extract_boolean() ? Boolean.TRUE : Boolean.FALSE);
            }
            if (name.equals("StopTimeSupported")) {
                this.m_props.put("StopTimeSupported", value.extract_boolean() ? Boolean.TRUE : Boolean.FALSE);
            }
            if (name.equals("MaxEventsPerConsumer")) {
                this.m_props.put("MaxEventsPerConsumer", new Integer(value.extract_long()));
            }
            if (name.equals("OrderPolicy")) {
                this.m_props.put("OrderPolicy", new Short(value.extract_short()));
            }
            if (name.equals("DiscardPolicy")) {
                this.m_props.put("DiscardPolicy", new Short(value.extract_short()));
            }
            if (name.equals("MaximumBatchSize")) {
                this.m_props.put("MaximumBatchSize", new Integer(value.extract_long()));
            }
            if (name.equals("PacingInterval")) {
                this.m_props.put("PacingInterval", new Long(TimeTHelper.extract(value)));
            }
            ++i;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.m_props.toString() + "]";
    }
}

