/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ChannelNotFound;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryPOA;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.notify.ChannelFactoryManagement;
import org.openorb.notify.Logger;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.PropertiesValidator;
import org.openorb.notify.impl.EventChannelImpl;
import org.openorb.notify.impl.FilterFactoryImpl;

public class EventChannelFactoryImpl
extends EventChannelFactoryPOA
implements ChannelFactoryManagement {
    private static final String FACTORY_OBJ_ID = "DefaultFilterFactory";
    public static final int MAX_PERFORMANCE_POLICY = 0;
    public static final int MAX_RESOURCE_POLICY = 1;
    private ORB m_orb;
    private POA m_poa;
    private FilterFactoryImpl m_filterFactory;
    private Hashtable m_channels = new Hashtable();
    private int m_nextChannelId = 0;
    private TreeMap m_recycledChannelIds = new TreeMap();
    private PropertiesRepository m_propertiesRepository;
    private final Logger m_logger;

    public EventChannelFactoryImpl(ORB orb, POA poa, PropertiesRepository propertiesRepository, Logger logger) {
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_propertiesRepository = propertiesRepository;
        this.m_logger = logger;
        this.m_filterFactory = new FilterFactoryImpl(this.m_orb, this.m_poa, logger.getFilterLogger());
        try {
            this.m_poa.activate_object_with_id(FACTORY_OBJ_ID.getBytes(), (Servant)this.m_filterFactory);
        }
        catch (ObjectAlreadyActive ex) {
            ex.printStackTrace();
            this.getLogger().error("Exception while creating event channel factory.", (Throwable)ex);
        }
        catch (ServantAlreadyActive ex) {
            ex.printStackTrace();
            this.getLogger().error("Exception while creating event channel factory.", (Throwable)ex);
        }
        catch (WrongPolicy ex) {
            ex.printStackTrace();
            this.getLogger().error("Exception while creating event channel factory.", (Throwable)ex);
        }
    }

    public POA getPOA() {
        return this.m_poa;
    }

    public synchronized EventChannel create_channel(Property[] initial_qos, Property[] initial_admin, IntHolder id) throws UnsupportedQoS, UnsupportedAdmin {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("create_channel");
        }
        try {
            PropertiesValidator.checkQoSProperties(initial_qos, this.m_orb);
            Property[] validatedQoS = PropertiesValidator.validateQoSProperties(initial_qos, this.m_orb);
            PropertiesValidator.checkAdminProperties(initial_admin, this.m_orb);
            Property[] validatedAdmin = PropertiesValidator.validateAdminProperties(initial_admin, this.m_orb);
            id.value = !this.m_recycledChannelIds.isEmpty() ? (Integer)this.m_recycledChannelIds.remove(this.m_recycledChannelIds.firstKey()) : this.m_nextChannelId++;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Channel created with id " + id.value + ".");
            }
            EventChannelImpl channel = new EventChannelImpl(this, this.m_orb, this.m_poa, validatedQoS, validatedAdmin, id.value, this.m_logger);
            this.m_poa.activate_object_with_id(channel.getPid(), (Servant)channel);
            this.m_channels.put(new Integer(id.value), EventChannelHelper.narrow(this.m_poa.id_to_reference(channel.getPid())));
            return EventChannelHelper.narrow(this.m_poa.id_to_reference(channel.getPid()));
        }
        catch (Throwable ex) {
            this.getLogger().error("Unexpected exception.", ex);
            return null;
        }
    }

    public int[] get_all_channels() {
        int[] ids = new int[this.m_channels.size()];
        int i = 0;
        Enumeration e = this.m_channels.keys();
        while (e.hasMoreElements()) {
            ids[i++] = (Integer)e.nextElement();
        }
        return ids;
    }

    public EventChannel get_event_channel(int id) throws ChannelNotFound {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get_event_channel: id=" + id);
        }
        if (!this.m_channels.containsKey(new Integer(id))) {
            throw new ChannelNotFound();
        }
        return EventChannelHelper.narrow((Object)this.m_channels.get(new Integer(id)));
    }

    public FilterFactoryImpl getFilterFactory() {
        return this.m_filterFactory;
    }

    public void channelRecovered(int id, EventChannelImpl channel) {
        try {
            this.m_channels.put(new Integer(id), this.m_poa.id_to_reference(channel.getPid()));
            if (id >= this.m_nextChannelId) {
                this.m_nextChannelId = id + 1;
            }
        }
        catch (Throwable ex) {
            this.getLogger().error("Unexpected exception.", ex);
        }
    }

    public void recoveryFinished() {
        int i = 0;
        while (i < this.m_nextChannelId) {
            if (!this.m_channels.containsKey(new Integer(i))) {
                this.m_recycledChannelIds.put(new Integer(i), new Integer(i));
            }
            ++i;
        }
    }

    public void channelDestroyed(int id) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Channel destroyed with id " + id + ".");
        }
        this.m_channels.remove(new Integer(id));
        this.m_recycledChannelIds.put(new Integer(id), new Integer(id));
    }

    public java.lang.Object getProperty(String key) {
        return this.m_propertiesRepository.getProperty(key);
    }

    public boolean isQueueMaxPerformance() {
        return (Integer)this.m_propertiesRepository.getProperty("EventQueuesPolicy") == 0;
    }

    public boolean isSupplierAdminMaxPerformance() {
        int policy = (Integer)this.m_propertiesRepository.getProperty("SupplierAdminsThreadPolicy");
        return policy == 0;
    }

    public boolean isConsumerAdminMaxPerformance() {
        int policy = (Integer)this.m_propertiesRepository.getProperty("ConsumerAdminsThreadPolicy");
        return policy == 0;
    }

    public boolean isSupplierProxyMaxPerformance() {
        int policy = (Integer)this.m_propertiesRepository.getProperty("SupplierProxiesThreadPolicy");
        return policy == 0;
    }

    public boolean isConsumerProxyMaxPerformance() {
        int policy = (Integer)this.m_propertiesRepository.getProperty("ConsumerProxiesThreadPolicy");
        return policy == 0;
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger.getFactoryLogger();
    }
}

