/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.ConsumerAdmin;
import org.omg.CosEventChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelPOA;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyChannelAdmin.SupplierAdminHelper;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.notify.ChannelManagement;
import org.openorb.notify.EventDispatcher;
import org.openorb.notify.EventReceiver;
import org.openorb.notify.Logger;
import org.openorb.notify.PersistenceManagement;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.impl.ConsumerAdminImpl;
import org.openorb.notify.impl.EventChannelFactoryImpl;
import org.openorb.notify.impl.SupplierAdminImpl;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.EventChannel;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.queue.EventQueue;
import org.openorb.notify.queue.EventQueueFactory;
import org.openorb.notify.queue.EventQueueReceiver;

public class EventChannelImpl
extends EventChannelPOA
implements EventReceiver,
PersistenceManagement,
ChannelManagement {
    private ORB m_orb;
    private POA m_poa;
    private EventChannelFactoryImpl m_factory;
    private PropertiesRepository m_propertiesRepository;
    private EventChannel m_pssEventChannel;
    private EventQueue m_queue;
    private EventQueueReceiver m_receiver;
    private int m_maxSuppliers = 0;
    private int m_maxConsumers = 0;
    private int m_maxQueueLength = 0;
    private int m_undeliveredEvents = 0;
    private Hashtable m_undeliveredEventsList;
    private final Logger m_logger;

    public EventChannelImpl(EventChannelFactoryImpl factory, ORB orb, POA poa, Property[] qosProperties, Property[] adminProperties, int channelId, Logger logger) {
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_factory = factory;
        this.m_logger = logger;
        this.m_propertiesRepository = new PropertiesRepository(qosProperties, adminProperties);
        this.m_pssEventChannel = PersistenceRepository.getEventChannelHome(this.m_propertiesRepository.isConnectionReliable()).create(channelId, new ConnectionInfo(0, new byte[0], null), new ConnectionInfo[0], new ConnectionInfo(0, new byte[0], null), new ConnectionInfo[0], qosProperties, adminProperties, 1, 1, 0, 0, new EventTypeInfo[0], new EventTypeInfo[0]);
        this.m_undeliveredEventsList = new Hashtable();
        this.configureQueue();
        this.configureReceiver();
    }

    public EventChannelImpl(EventChannelFactoryImpl factory, EventChannel pssEventChannel, POA poa, Logger logger) {
        this.m_orb = factory._orb();
        this.m_poa = poa;
        this.m_factory = factory;
        this.m_pssEventChannel = pssEventChannel;
        this.m_logger = logger;
        this.m_propertiesRepository = new PropertiesRepository(this.m_pssEventChannel.qos_properties(), this.m_pssEventChannel.admin_properties());
        this.m_undeliveredEventsList = new Hashtable();
        this.configureQueue();
        this.configureReceiver();
    }

    private void configureQueue() {
        this.m_queue = EventQueueFactory.createAdminQueue("[CH] " + this.getId(), this.m_propertiesRepository, this.isEventQueueLogged(), this.isFilterEvaluationLogged(), this.getLogger().getChildLogger("queue"));
    }

    private void configureReceiver() {
        this.m_receiver = new EventQueueReceiver("[CH EQR] " + this.getId(), this.m_queue, this.getLogger());
        this.m_receiver.startThread();
    }

    public EventChannelFactory MyFactory() {
        try {
            return EventChannelFactoryHelper.narrow(this.m_poa.servant_to_reference((Servant)this.m_factory));
        }
        catch (ServantNotActive ex) {
            this.getLogger().error("Exception while returning event channel factory.", (Throwable)ex);
        }
        catch (WrongPolicy ex) {
            this.getLogger().error("Exception while returning event channel factory.", (Throwable)ex);
        }
        return null;
    }

    public org.omg.CosNotifyChannelAdmin.ConsumerAdmin default_consumer_admin() {
        this.checkDefaultConsumer();
        return org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(this.m_pssEventChannel.def_consumer_admin().reference);
    }

    public SupplierAdmin default_supplier_admin() {
        this.checkDefaultSupplier();
        return SupplierAdminHelper.narrow(this.m_pssEventChannel.def_supplier_admin().reference);
    }

    public FilterFactory default_filter_factory() {
        try {
            return FilterFactoryHelper.narrow(this.m_poa.servant_to_reference((Servant)this.m_factory.getFilterFactory()));
        }
        catch (ServantNotActive ex) {
            this.getLogger().error("Exception while returning default filter factory.", (Throwable)ex);
        }
        catch (WrongPolicy ex) {
            this.getLogger().error("Exception while returning default filter factory.", (Throwable)ex);
        }
        return null;
    }

    public org.omg.CosNotifyChannelAdmin.ConsumerAdmin new_for_consumers(InterFilterGroupOperator op, IntHolder id) {
        EventChannel eventChannel = this.m_pssEventChannel;
        synchronized (eventChannel) {
            id.value = this.m_pssEventChannel.next_consumer_admin_id();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getId() + " ConsumerAdmin created with id " + id.value + ".");
            }
            ConsumerAdminImpl newConsumerAdmin = new ConsumerAdminImpl(this, this.m_orb, this.m_poa, op, id.value, this.m_pssEventChannel.id(), this.m_pssEventChannel.qos_properties(), this.m_logger);
            try {
                this.m_poa.activate_object_with_id(newConsumerAdmin.getPid(), (Servant)newConsumerAdmin);
                this.reportConsumerAdminCreated();
                ConnectionInfo[] consumers = this.m_pssEventChannel.consumer_admins();
                ConnectionInfo[] new_consumers = new ConnectionInfo[consumers.length + 1];
                int i = 0;
                while (i < consumers.length) {
                    new_consumers[i] = consumers[i];
                    ++i;
                }
                new_consumers[consumers.length] = new ConnectionInfo(id.value, newConsumerAdmin.getPid(), this.m_poa.id_to_reference(newConsumerAdmin.getPid()));
                this.m_pssEventChannel.next_consumer_admin_id(id.value + 1);
                this.m_pssEventChannel.consumer_admins(new_consumers);
                this.m_receiver.addDispatcher(newConsumerAdmin);
                org.omg.CosNotifyChannelAdmin.ConsumerAdmin consumerAdmin = org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(this.m_poa.id_to_reference(newConsumerAdmin.getPid()));
                return consumerAdmin;
            }
            catch (Throwable ex) {
                this.getLogger().error("Unexpected exception.", ex);
                org.omg.CosNotifyChannelAdmin.ConsumerAdmin consumerAdmin = null;
                return consumerAdmin;
            }
        }
    }

    public SupplierAdmin new_for_suppliers(InterFilterGroupOperator op, IntHolder id) {
        EventChannel eventChannel = this.m_pssEventChannel;
        synchronized (eventChannel) {
            id.value = this.m_pssEventChannel.next_supplier_admin_id();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getId() + " SupplierAdmin created with id " + id.value + ".");
            }
            SupplierAdminImpl newSupplierAdmin = new SupplierAdminImpl(this, this.m_orb, this.m_poa, op, id.value, this.m_pssEventChannel.id(), this.m_pssEventChannel.qos_properties(), this.m_logger);
            try {
                this.m_poa.activate_object_with_id(newSupplierAdmin.getPid(), (Servant)newSupplierAdmin);
                ConnectionInfo[] suppliers = this.m_pssEventChannel.supplier_admins();
                ConnectionInfo[] new_suppliers = new ConnectionInfo[suppliers.length + 1];
                int i = 0;
                while (i < suppliers.length) {
                    new_suppliers[i] = suppliers[i];
                    ++i;
                }
                new_suppliers[suppliers.length] = new ConnectionInfo(id.value, newSupplierAdmin.getPid(), this.m_poa.id_to_reference(newSupplierAdmin.getPid()));
                this.m_pssEventChannel.next_supplier_admin_id(id.value + 1);
                this.m_pssEventChannel.supplier_admins(new_suppliers);
                SupplierAdmin supplierAdmin = SupplierAdminHelper.narrow(this.m_poa.id_to_reference(newSupplierAdmin.getPid()));
                return supplierAdmin;
            }
            catch (Throwable ex) {
                this.getLogger().error("Unexpected exception.", ex);
                SupplierAdmin supplierAdmin = null;
                return supplierAdmin;
            }
        }
    }

    public org.omg.CosNotifyChannelAdmin.ConsumerAdmin get_consumeradmin(int id) throws AdminNotFound {
        EventChannel eventChannel = this.m_pssEventChannel;
        synchronized (eventChannel) {
            if (id == 0) {
                org.omg.CosNotifyChannelAdmin.ConsumerAdmin consumerAdmin = this.default_consumer_admin();
                return consumerAdmin;
            }
            ConnectionInfo[] consumerAdmins = this.m_pssEventChannel.consumer_admins();
            int i = 0;
            while (i < consumerAdmins.length) {
                if (consumerAdmins[i].id == id) {
                    org.omg.CosNotifyChannelAdmin.ConsumerAdmin consumerAdmin = org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(consumerAdmins[i].reference);
                    return consumerAdmin;
                }
                ++i;
            }
            throw new AdminNotFound();
        }
    }

    public SupplierAdmin get_supplieradmin(int id) throws AdminNotFound {
        EventChannel eventChannel = this.m_pssEventChannel;
        synchronized (eventChannel) {
            if (id == 0) {
                SupplierAdmin supplierAdmin = this.default_supplier_admin();
                return supplierAdmin;
            }
            ConnectionInfo[] supplierAdmins = this.m_pssEventChannel.supplier_admins();
            int i = 0;
            while (i < supplierAdmins.length) {
                if (supplierAdmins[i].id == id) {
                    SupplierAdmin supplierAdmin = SupplierAdminHelper.narrow(supplierAdmins[i].reference);
                    return supplierAdmin;
                }
                ++i;
            }
            throw new AdminNotFound();
        }
    }

    public int[] get_all_consumeradmins() {
        EventChannel eventChannel = this.m_pssEventChannel;
        synchronized (eventChannel) {
            ConnectionInfo[] consumers = this.m_pssEventChannel.consumer_admins();
            int[] result = new int[consumers.length];
            int i = 0;
            while (i < result.length) {
                result[i] = consumers[i].id;
                ++i;
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public int[] get_all_supplieradmins() {
        EventChannel eventChannel = this.m_pssEventChannel;
        synchronized (eventChannel) {
            ConnectionInfo[] suppliers = this.m_pssEventChannel.supplier_admins();
            int[] result = new int[suppliers.length];
            int i = 0;
            while (i < result.length) {
                result[i] = suppliers[i].id;
                ++i;
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public Property[] get_qos() {
        return this.m_pssEventChannel.qos_properties();
    }

    public void set_qos(Property[] qos) throws UnsupportedQoS {
        throw new NO_IMPLEMENT();
    }

    public void validate_qos(Property[] required_qos, NamedPropertyRangeSeqHolder available_qos) throws UnsupportedQoS {
        throw new NO_IMPLEMENT();
    }

    public Property[] get_admin() {
        return this.m_pssEventChannel.admin_properties();
    }

    public void set_admin(Property[] admin) throws UnsupportedAdmin {
        throw new NO_IMPLEMENT();
    }

    public ConsumerAdmin for_consumers() {
        this.checkDefaultConsumer();
        return ConsumerAdminHelper.narrow(this.m_pssEventChannel.def_consumer_admin().reference);
    }

    public org.omg.CosEventChannelAdmin.SupplierAdmin for_suppliers() {
        this.checkDefaultSupplier();
        return org.omg.CosEventChannelAdmin.SupplierAdminHelper.narrow(this.m_pssEventChannel.def_supplier_admin().reference);
    }

    public void destroy() {
        Object adminRef;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getId() + " Disconnecting admins and proxies.");
        }
        if ((adminRef = this.m_pssEventChannel.def_consumer_admin().reference) != null) {
            org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(adminRef).destroy();
        }
        ConnectionInfo[] admins = this.m_pssEventChannel.consumer_admins();
        int i = 0;
        while (i < admins.length) {
            if (admins[i].id > 0) {
                org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(admins[i].reference).destroy();
            }
            ++i;
        }
        adminRef = this.m_pssEventChannel.def_supplier_admin().reference;
        if (adminRef != null) {
            SupplierAdminHelper.narrow(adminRef).destroy();
        }
        admins = this.m_pssEventChannel.supplier_admins();
        int i2 = 0;
        while (i2 < admins.length) {
            if (admins[i2].id > 0) {
                SupplierAdminHelper.narrow(admins[i2].reference).destroy();
            }
            ++i2;
        }
        this.m_receiver.stopThread();
        this.m_factory.channelDestroyed(this.m_pssEventChannel.id());
        this.m_pssEventChannel.destroy_object();
        try {
            this.m_poa.deactivate_object(this._object_id());
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy ex) {
            // empty catch block
        }
    }

    public void receiveEvent(java.lang.Object event) {
        ++this.m_undeliveredEvents;
        this.m_receiver.pushEvent(event);
    }

    private void checkDefaultConsumer() {
        if (this.m_pssEventChannel.def_consumer_admin().reference != null) {
            return;
        }
        try {
            ConsumerAdminImpl defaultConsumerAdmin = new ConsumerAdminImpl(this, this.m_orb, this.m_poa, InterFilterGroupOperator.OR_OP, 0, this.m_pssEventChannel.id(), this.m_pssEventChannel.qos_properties(), this.m_logger);
            this.m_poa.activate_object_with_id(defaultConsumerAdmin.getPid(), (Servant)defaultConsumerAdmin);
            this.m_pssEventChannel.def_consumer_admin(new ConnectionInfo(0, defaultConsumerAdmin.getPid(), org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(this.m_poa.id_to_reference(defaultConsumerAdmin.getPid()))));
            this.m_receiver.addDispatcher(defaultConsumerAdmin);
            this.reportConsumerAdminCreated();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getId() + " Default ConsumerAdmin created with id 0.");
            }
        }
        catch (Throwable ex) {
            this.getLogger().error("Unexpected exception.", ex);
        }
    }

    private void checkDefaultSupplier() {
        try {
            if (this.m_pssEventChannel.def_supplier_admin().reference != null) {
                return;
            }
            SupplierAdminImpl defaultSupplierAdmin = new SupplierAdminImpl(this, this.m_orb, this.m_poa, InterFilterGroupOperator.OR_OP, 0, this.m_pssEventChannel.id(), this.m_pssEventChannel.qos_properties(), this.m_logger);
            this.m_poa.activate_object_with_id(defaultSupplierAdmin.getPid(), (Servant)defaultSupplierAdmin);
            this.m_pssEventChannel.def_supplier_admin(new ConnectionInfo(0, defaultSupplierAdmin.getPid(), SupplierAdminHelper.narrow(this.m_poa.id_to_reference(defaultSupplierAdmin.getPid()))));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getId() + " Default SupplierAdmin created with id 0.");
            }
        }
        catch (Throwable ex) {
            this.getLogger().error("Unexpected exception.", ex);
        }
    }

    public String getId() {
        return "[" + this.m_pssEventChannel.id() + "]";
    }

    public void consumerAdminRecovered(int id, ConsumerAdminImpl consumerAdmin) {
        this.m_receiver.addDispatcher(consumerAdmin);
    }

    public void supplierAdminRecovered(int id, SupplierAdminImpl supplierAdmin) {
    }

    public void reportConsumerAdminDestruction(byte[] adminPid) {
        this.getLogger().info(this.getId() + " Disconnecting consumer admin.");
        ConnectionInfo[] consumers = this.m_pssEventChannel.consumer_admins();
        if (consumers.length == 0) {
            return;
        }
        ArrayList<ConnectionInfo> newConsumersList = new ArrayList<ConnectionInfo>(consumers.length - 1);
        int i = 0;
        while (i < consumers.length) {
            if (Arrays.equals(consumers[i].pid, adminPid)) {
                try {
                    this.m_receiver.removeDispatcher((EventDispatcher)this.m_poa.id_to_servant(consumers[i].pid));
                }
                catch (ObjectNotActive ex) {
                    this.m_logger.getCAdminLogger().error(this.getId() + " Error while removing dispatcher.", (Throwable)ex);
                }
                catch (WrongPolicy ex) {
                    this.m_logger.getCAdminLogger().error(this.getId() + " Error while removing dispatcher.", (Throwable)ex);
                }
            } else {
                newConsumersList.add(consumers[i]);
            }
            ++i;
        }
        ConnectionInfo[] new_consumers = new ConnectionInfo[newConsumersList.size()];
        newConsumersList.toArray(new_consumers);
        this.m_pssEventChannel.consumer_admins(new_consumers);
    }

    public void reportSupplierAdminDestruction(byte[] adminPid) {
        ConnectionInfo[] suppliers;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting supplier admin.");
        }
        if ((suppliers = this.m_pssEventChannel.supplier_admins()).length == 0) {
            return;
        }
        ConnectionInfo[] new_suppliers = new ConnectionInfo[suppliers.length - 1];
        int j = 0;
        int i = 0;
        while (i < suppliers.length) {
            if (!Arrays.equals(suppliers[i].pid, adminPid)) {
                new_suppliers[j++] = suppliers[i];
            }
            ++i;
        }
        this.m_pssEventChannel.supplier_admins(new_suppliers);
    }

    public synchronized void reportSupplierConnection() {
        this.m_pssEventChannel.connected_consumers(this.m_pssEventChannel.connected_consumers() + 1);
    }

    public synchronized boolean canConnectConsumer() {
        if (this.m_maxConsumers == 0) {
            return true;
        }
        return this.m_maxConsumers > this.m_pssEventChannel.connected_consumers();
    }

    public synchronized void reportConsumerConnection() {
        this.m_pssEventChannel.connected_suppliers(this.m_pssEventChannel.connected_suppliers() + 1);
    }

    public synchronized boolean canConnectSupplier() {
        if (this.m_maxSuppliers == 0) {
            return true;
        }
        return this.m_maxSuppliers > this.m_pssEventChannel.connected_suppliers();
    }

    public synchronized void reportSupplierDisconnection() {
        this.m_pssEventChannel.connected_consumers(this.m_pssEventChannel.connected_consumers() - 1);
    }

    public synchronized void reportConsumerDisconnection() {
        this.m_pssEventChannel.connected_suppliers(this.m_pssEventChannel.connected_suppliers() - 1);
    }

    public synchronized void reportEventDelivery(int consumerAdminId, int eventPid) {
        Integer deliveriesForEvent = (Integer)this.m_undeliveredEventsList.get(new Integer(eventPid));
        deliveriesForEvent = deliveriesForEvent == null ? new Integer(1) : new Integer(deliveriesForEvent + 1);
        if (deliveriesForEvent == this.m_pssEventChannel.consumer_admins().length + (this.m_pssEventChannel.def_consumer_admin().reference == null ? 0 : 1)) {
            this.m_undeliveredEventsList.remove(new Integer(eventPid));
            --this.m_undeliveredEvents;
        } else {
            this.m_undeliveredEventsList.put(new Integer(eventPid), deliveriesForEvent);
        }
    }

    private synchronized void reportConsumerAdminCreated() {
        Enumeration e = this.m_undeliveredEventsList.keys();
        while (e.hasMoreElements()) {
            java.lang.Object key = e.nextElement();
            int i = (Integer)this.m_undeliveredEventsList.get(key);
            this.m_undeliveredEventsList.put(key, new Integer(++i));
        }
    }

    public synchronized boolean canDispatchNewEvent() {
        if (this.m_maxQueueLength == 0) {
            return true;
        }
        return this.m_maxQueueLength > this.m_undeliveredEvents;
    }

    public synchronized void reportEventTypesPublished(EventType[] published, EventType[] unpublished, Object source) {
    }

    public synchronized void reportEventTypesSubscribed(EventType[] subscribed, EventType[] unsubscribed, Object source) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("#" + this.getId() + " Event types subscribe modified.");
        }
    }

    public java.lang.Object getNotifyProperty(String key) {
        return this.m_factory.getProperty(key);
    }

    public boolean isQueueMaxPerformance() {
        return this.m_factory.isQueueMaxPerformance();
    }

    public boolean isSupplierAdminMaxPerformance() {
        return this.m_factory.isSupplierAdminMaxPerformance();
    }

    public boolean isConsumerAdminMaxPerformance() {
        return this.m_factory.isConsumerAdminMaxPerformance();
    }

    public boolean isSupplierProxyMaxPerformance() {
        return this.m_factory.isSupplierProxyMaxPerformance();
    }

    public boolean isConsumerProxyMaxPerformance() {
        return this.m_factory.isConsumerProxyMaxPerformance();
    }

    public boolean isEventQueueLogged() {
        return (Boolean)this.m_factory.getProperty("LogEventQueue");
    }

    public boolean isFilterEvaluationLogged() {
        return (Boolean)this.m_factory.getProperty("LogFilterEvaluation");
    }

    public byte[] getPid() {
        return this.m_pssEventChannel.get_pid();
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger.getChannelLogger();
    }
}

