/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import org.apache.avalon.framework.logger.Logger;
import org.openorb.notify.EventReceiver;
import org.openorb.notify.NotifyThread;
import org.openorb.notify.queue.EventQueue;

public class EventQueueDispatcher
extends NotifyThread {
    private final EventQueue m_queue;
    private final EventReceiver m_receiver;

    public EventQueueDispatcher(String id, EventQueue queue, EventReceiver receiver, Logger logger) {
        super(id, logger.getChildLogger("thread"));
        this.m_queue = queue;
        this.m_receiver = receiver;
    }

    public void pushEvent(Object event) {
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            this.m_queue.pushEvent(event);
        }
        if (this.isRunning()) {
            this.notifyThread();
        } else {
            this.doDelivery();
        }
    }

    public void pushEvents(Object[] events) {
        int i;
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            i = 0;
            while (i < events.length) {
                this.m_queue.pushEvent(events[i]);
                ++i;
            }
        }
        if (this.isRunning()) {
            this.notifyThread();
        } else {
            i = 0;
            while (i < events.length) {
                this.doDelivery();
                ++i;
            }
        }
    }

    private void doDelivery() {
        Object event;
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            if (this.m_queue.isEmpty()) {
                return;
            }
            event = this.m_queue.pullEvent();
        }
        if (event != null) {
            this.m_receiver.receiveEvent(event);
        }
    }

    public void run() {
        while (!this.finishRunning()) {
            this.waitForEvents();
            this.doDelivery();
        }
    }

    private void notifyThread() {
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            this.m_queue.notify();
        }
    }

    private void waitForEvents() {
        if (!this.isRunning()) {
            return;
        }
        try {
            EventQueue eventQueue = this.m_queue;
            synchronized (eventQueue) {
                while (this.m_queue.isEmpty()) {
                    this.m_queue.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean finishRunning() {
        if (this.shouldFinishWork()) {
            EventQueue eventQueue = this.m_queue;
            synchronized (eventQueue) {
                if (this.m_queue.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return !this.isRunning();
    }

    public void stopThread() {
        super.stopThread();
        this.notifyThread();
    }
}

