/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import org.apache.avalon.framework.logger.Logger;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.queue.AdminQueue;
import org.openorb.notify.queue.ConsumerProxyQueue;
import org.openorb.notify.queue.FilterableEventQueue;
import org.openorb.notify.queue.SupplierProxyQueue;

public final class EventQueueFactory {
    private EventQueueFactory() {
    }

    public static FilterableEventQueue createAdminQueue(String id, PropertiesRepository props, boolean isEventsLogged, boolean isFiltersEvaluationLogged, Logger logger) {
        AdminQueue adminQueue = new AdminQueue(id, props.getOrderPolicy(), props.isEventReliable(), logger);
        adminQueue.setEventsLogged(isEventsLogged);
        adminQueue.setFiltersEvaluationLogged(isFiltersEvaluationLogged);
        return adminQueue;
    }

    public static FilterableEventQueue createConsumerProxyQueue(String id, PropertiesRepository props, boolean isPerformance, boolean isEventsLogged, boolean isFiltersEvaluationLogged, Logger logger) {
        ConsumerProxyQueue cpq = new ConsumerProxyQueue(id, props.getOrderPolicy(), props.isEventReliable(), props.getPriority(), props.getTimeout(), isPerformance, logger);
        cpq.setEventLogged(isEventsLogged);
        cpq.setFiltersEvaluationLogged(isFiltersEvaluationLogged);
        return cpq;
    }

    public static FilterableEventQueue createSupplierProxyQueue(String id, PropertiesRepository props, boolean isEventsLogged, boolean isFiltersEvaluationLogged, Logger logger) {
        SupplierProxyQueue spq = new SupplierProxyQueue(id, props.getOrderPolicy(), props.isEventReliable(), logger);
        spq.setIsEventLogged(isEventsLogged);
        spq.setFiltersEvaluationLogged(isFiltersEvaluationLogged);
        return spq;
    }
}

