/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CosEventComm.Disconnected;
import org.openorb.notify.EventReceiver;
import org.openorb.notify.NotifyThread;
import org.openorb.notify.SupplierProxyManagement;
import org.openorb.notify.Util;
import org.openorb.notify.queue.FilterableEventQueue;

public abstract class Puller
extends NotifyThread {
    protected final FilterableEventQueue m_queue;
    protected final EventReceiver m_receiver;
    protected final SupplierProxyManagement m_proxy;
    private boolean m_isConnectionActive;
    protected final long m_pullThreadLatency;

    public Puller(String id, FilterableEventQueue queue, EventReceiver receiver, SupplierProxyManagement proxy, long pullThreadLatency, Logger logger) {
        super(id, logger.getChildLogger("thread"));
        this.m_queue = queue;
        this.m_receiver = receiver;
        this.m_proxy = proxy;
        this.m_pullThreadLatency = pullThreadLatency;
    }

    public void setConnectionActive(boolean isConnectionActive) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_isConnectionActive = isConnectionActive;
        }
    }

    protected boolean isConnectionActive() {
        Object object = this.m_stateLock;
        synchronized (object) {
            boolean bl = this.m_isConnectionActive;
            return bl;
        }
    }

    public void run() {
        BooleanHolder hasEvent = new BooleanHolder();
        while (!this.finishRunning()) {
            boolean hadEvent;
            block10: {
                hadEvent = false;
                if (this.isConnectionActive()) {
                    try {
                        hadEvent = this.pullEvents(hasEvent);
                        this.getLogger().debug("received event from pull supplier");
                    }
                    catch (Disconnected ex) {
                        Object var6_9;
                        try {
                            try {
                                this.disconnect_pull_supplier();
                            }
                            catch (SystemException sysex) {
                                this.getLogger().error("disconnect pull supplier failed", (Throwable)sysex);
                                var6_9 = null;
                                this.m_proxy.reportClientDisconnection();
                                this.setRunning(false);
                                break block10;
                            }
                            var6_9 = null;
                            this.m_proxy.reportClientDisconnection();
                            this.setRunning(false);
                        }
                        catch (Throwable throwable) {
                            var6_9 = null;
                            this.m_proxy.reportClientDisconnection();
                            this.setRunning(false);
                            throw throwable;
                        }
                    }
                    catch (OBJECT_NOT_EXIST e) {
                        this.getLogger().debug("pull supplier does not exist, disconnecting it", (Throwable)e);
                        this.m_proxy.reportClientDisconnection();
                        this.setRunning(false);
                    }
                    catch (SystemException sysex) {
                        this.getLogger().debug("pull supplier temporarily unavailable", (Throwable)sysex);
                    }
                }
            }
            if (hadEvent || !this.isRunning()) continue;
            Util.sleep(this.m_pullThreadLatency, this.getLogger());
        }
    }

    protected abstract Object try_pull_event(BooleanHolder var1) throws Disconnected, SystemException;

    protected boolean pullEvents(BooleanHolder hasEvent) throws Disconnected, SystemException {
        Object pulledEvent;
        hasEvent.value = false;
        Object event = this.try_pull_event(hasEvent);
        if (!hasEvent.value) {
            return false;
        }
        FilterableEventQueue filterableEventQueue = this.m_queue;
        synchronized (filterableEventQueue) {
            if (!this.m_queue.pushEvent(event)) {
                boolean bl = false;
                return bl;
            }
        }
        FilterableEventQueue filterableEventQueue2 = this.m_queue;
        synchronized (filterableEventQueue2) {
            if (this.m_queue.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            pulledEvent = this.m_queue.pullEvent();
        }
        this.m_receiver.receiveEvent(pulledEvent);
        return true;
    }

    protected abstract void disconnect_pull_supplier();

    protected boolean finishRunning() {
        if (this.shouldFinishWork()) {
            FilterableEventQueue filterableEventQueue = this.m_queue;
            synchronized (filterableEventQueue) {
                if (this.m_queue.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return !this.isRunning();
    }
}

