/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxyPullSupplier;
import org.omg.CosNotifyChannelAdmin.ProxyPullSupplierHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.openorb.notify.examples.simple.ORBObjectRef;

public class AnyPullConsumer {
    public static final String HDR = "[AnyPullConsumer] ";

    public static void main(String[] args) {
        try {
            System.out.println("[AnyPullConsumer] Start example");
            System.out.println("[AnyPullConsumer] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[AnyPullConsumer] Get the event channel");
            EventChannel eventChannel = AnyPullConsumer.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[AnyPullConsumer] No event channel available");
                return;
            }
            System.out.println("[AnyPullConsumer] Obtain the channel's default Consumer Admin");
            ConsumerAdmin consumerAdmin = eventChannel.default_consumer_admin();
            System.out.println("[AnyPullConsumer] Obtain a supplier proxy");
            IntHolder proxyId = new IntHolder();
            ProxySupplier proxySupplier = null;
            try {
                proxySupplier = consumerAdmin.obtain_notification_pull_supplier(ClientType.ANY_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullConsumer] Narrow to a proxy pull supplier");
            ProxyPullSupplier proxyPullSupplier = null;
            try {
                proxyPullSupplier = ProxyPullSupplierHelper.narrow((Object)proxySupplier);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullConsumer] Connect to the supplier proxy: null pull consumer");
            try {
                proxyPullSupplier.connect_any_pull_consumer(null);
            }
            catch (AlreadyConnected ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullConsumer] Pulling events...");
            boolean done = false;
            while (!done) {
                try {
                    System.out.println("[AnyPullConsumer] Pulling synchronously...");
                    Any event = proxyPullSupplier.pull();
                    done = AnyPullConsumer.showEvent(event);
                }
                catch (Disconnected ex) {
                    ex.printStackTrace(System.err);
                    return;
                }
            }
            System.out.println("[AnyPullConsumer] Disconnecting (removing) the supplier proxy");
            try {
                proxyPullSupplier.disconnect_pull_supplier();
            }
            catch (TRANSIENT ex) {
                ex.printStackTrace(System.err);
                return;
            }
            catch (COMM_FAILURE ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullConsumer] ORB Shutdown: pending=" + orb.work_pending());
            orb.shutdown(false);
        }
        catch (SystemException ex) {
            ex.printStackTrace(System.err);
            return;
        }
        System.out.println("[AnyPullConsumer] Terminate application");
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[AnyPullConsumer] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[AnyPullConsumer] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[AnyPullConsumer] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow((Object)o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[AnyPullConsumer] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            System.out.println("[AnyPullConsumer] Storing the new channel reference");
            objRef.set((Object)eventChannel);
        }
        return eventChannel;
    }

    public static boolean showEvent(Any anyEvent) {
        StructuredEvent event = StructuredEventHelper.extract((Any)anyEvent);
        boolean done = false;
        System.out.println("[AnyPullConsumer] \tFixed header: " + event.header.fixed_header.event_type.domain_name + "." + event.header.fixed_header.event_type.type_name + "." + event.header.fixed_header.event_name);
        System.out.println("[AnyPullConsumer] \tFilterable data:");
        int i = 0;
        while (i < event.filterable_data.length) {
            try {
                String name = event.filterable_data[i].name;
                String val = event.filterable_data[i].value.extract_string();
                System.out.println("[AnyPullConsumer] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return true;
            }
            ++i;
        }
        System.out.println("[AnyPullConsumer] \tVariable header:");
        int i2 = 0;
        while (i2 < event.header.variable_header.length) {
            try {
                String name = event.header.variable_header[i2].name;
                String val = event.header.variable_header[i2].value.extract_string();
                System.out.println("[AnyPullConsumer] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return true;
            }
            ++i2;
        }
        System.out.print("[AnyPullConsumer] \tRemainder: ");
        String msg = event.remainder_of_body.extract_string();
        System.out.println(msg);
        if (msg.toLowerCase().equals("done")) {
            done = true;
        }
        return done;
    }
}

