/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.openorb.notify.examples.simple.ORBObjectRef;
import org.openorb.notify.examples.simple.StructuredPullSupplierImpl;

public class StructuredPullSupplier {
    public static final String HDR = "[StructuredPullSupplier] ";
    public static final int NUM_PUSH = 10;

    public static void main(String[] args) {
        try {
            System.out.println("[StructuredPullSupplier] Start example");
            System.out.println("[StructuredPullSupplier] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[StructuredPullSupplier] Get the event channel");
            EventChannel eventChannel = StructuredPullSupplier.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[StructuredPullSupplier] No event channel available");
                return;
            }
            System.out.println("[StructuredPullSupplier] Obtain the channel's default Supplier Admin");
            SupplierAdmin supplierAdmin = eventChannel.default_supplier_admin();
            System.out.println("[StructuredPullSupplier] Obtain a consumer proxy");
            IntHolder proxyId = new IntHolder();
            ProxyConsumer proxyConsumer = null;
            try {
                proxyConsumer = supplierAdmin.obtain_notification_pull_consumer(ClientType.STRUCTURED_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPullSupplier] Narrow to a proxy pull consumer");
            StructuredProxyPullConsumer structuredProxyPullConsumer = null;
            try {
                structuredProxyPullConsumer = StructuredProxyPullConsumerHelper.narrow((Object)proxyConsumer);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPullSupplier] Initialize RootPOA");
            Object objPOA = null;
            POA rootPOA = null;
            try {
                objPOA = orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPullSupplier] Narrow the CORBA Object reference to a POA");
            try {
                rootPOA = POAHelper.narrow((Object)objPOA);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPullSupplier] Create the pull supplier and activate on root POA");
            StructuredPullSupplierImpl pullSupplier = new StructuredPullSupplierImpl(orb, rootPOA);
            System.out.println("[StructuredPullSupplier] Connect to the consumer proxy: pull supplier");
            try {
                structuredProxyPullConsumer.connect_structured_pull_supplier(pullSupplier.structuredPullSupplier());
            }
            catch (AlreadyConnected ex) {
                ex.printStackTrace(System.err);
                return;
            }
            catch (TypeError ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPullSupplier] The server is ready...");
            orb.run();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[StructuredPullSupplier] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[StructuredPullSupplier] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[StructuredPullSupplier] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow((Object)o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[StructuredPullSupplier] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            System.out.println("[StructuredPullSupplier] Storing the new channel reference");
            objRef.set((Object)eventChannel);
        }
        return eventChannel;
    }
}

