/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.StructuredPullSupplier;
import org.omg.CosNotifyComm.StructuredPullSupplierPOA;
import org.omg.PortableServer.POA;

class StructuredPullSupplierImpl
extends StructuredPullSupplierPOA {
    public static final String HDR = "[StructuredPullSupplierImpl] ";
    public static final int MAX_EVENT_COUNT = 10;
    private ORB m_orb = null;
    private POA m_poa = null;
    private int m_event_count = 0;
    private StructuredPullSupplier m_ps = null;

    StructuredPullSupplierImpl(ORB orb, POA poa) {
        this.m_orb = orb;
        this.m_poa = poa;
        System.out.println("[StructuredPullSupplierImpl] Implicity conecting POA");
        this.m_ps = this._this(this.m_orb);
        System.out.println("[StructuredPullSupplierImpl] Activating on POA");
        try {
            this.m_poa.the_POAManager().activate();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public StructuredEvent try_pull_structured_event(BooleanHolder has_event) throws Disconnected {
        System.out.println("[StructuredPullSupplierImpl] Tried a pull");
        has_event.value = true;
        return this.pull_structured_event();
    }

    public StructuredEvent pull_structured_event() throws Disconnected {
        System.out.println("[StructuredPullSupplierImpl] Pulled");
        if (this.m_event_count == 10) {
            throw new Disconnected();
        }
        System.out.println("[StructuredPullSupplierImpl] Pulled...");
        StructuredEvent event = StructuredPullSupplierImpl.createEvent(this.m_orb, this.m_event_count++);
        return event;
    }

    public void disconnect_structured_pull_supplier() {
        System.out.println("[StructuredPullSupplierImpl] Disconnected...");
        System.out.println("[StructuredPullSupplierImpl] POA deactivate");
        this.destroy();
        System.out.println("[StructuredPullSupplierImpl] POA destroy");
        this._poa().destroy(true, false);
        System.out.println("[StructuredPullSupplierImpl] ORB Shutdown: pending=" + this.m_orb.work_pending());
        this.m_orb.shutdown(false);
        System.out.println("[StructuredPullSupplierImpl] Terminate application");
        System.exit(0);
    }

    public void subscription_change(EventType[] added, EventType[] removed) {
        System.out.println("[StructuredPullSupplierImpl] Subscription change...");
    }

    public StructuredPullSupplier structuredPullSupplier() {
        return this.m_ps;
    }

    public void destroy() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static StructuredEvent createEvent(ORB orb, int i) {
        Property property1;
        Property property0;
        String eventName = "StructuredEvent" + i;
        EventType eventType = new EventType("OpenORB", "examples");
        FixedEventHeader fixedEventHeader = new FixedEventHeader(eventType, eventName.toString());
        Property[] variableHeader = new Property[2];
        variableHeader[0] = new Property("variable:counter", orb.create_any());
        variableHeader[0].value.insert_string("" + i);
        variableHeader[1] = new Property("variable:(counter*10)", orb.create_any());
        variableHeader[1].value.insert_string("" + i * 10);
        EventHeader eventHeader = new EventHeader(fixedEventHeader, variableHeader);
        Property[] filterableData = new Property[2];
        filterableData[0] = property0 = new Property("filter:counter", orb.create_any());
        filterableData[0].value.insert_string("" + i);
        filterableData[1] = property1 = new Property("filter:(counter*10)", orb.create_any());
        filterableData[1].value.insert_string("" + i * 10);
        Any msg = orb.create_any();
        if (i == 9) {
            msg.insert_string("done");
        } else {
            msg.insert_string("continue");
        }
        StructuredEvent event = new StructuredEvent(eventHeader, filterableData, msg);
        return event;
    }
}

