/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.test;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.openorb.notify.test.ORBRunner;
import org.openorb.notify.test.ServiceRunner;

public class FilterTest
extends TestCase {
    private static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String FEATURE_INITIALIZER = "org.openorb.PI.FeatureInitializerClass.";
    private static final String HDR = "[FilterTest] ";
    private ServiceRunner m_service_runner = new ServiceRunner();
    private ORBRunner m_orb_runner;
    static /* synthetic */ Class class$org$openorb$notify$test$FilterTest;

    public FilterTest(String name) throws Exception {
        super(name);
        this.m_service_runner.setFileDataStoreDirectory(".");
        this.m_service_runner.setFileDataStoreName("notify");
        this.m_service_runner.start();
    }

    protected void setUp() throws Exception {
        System.out.println("Running FilterTest...");
        Properties props = new Properties();
        props.setProperty("openorb.ignoreXML", "true");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.iiop.IIOPProtocolInitializer", "");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.poa.POAInitializer", "");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.pss.Initializer", "");
        this.m_orb_runner = new ORBRunner(new String[0], props);
        this.m_orb_runner.start();
    }

    protected void tearDown() throws Exception {
        this.m_orb_runner.shutdown();
    }

    public void testSpecialConstraintCharacters() throws Exception {
        EventChannel eventChannel = FilterTest.getEventChannel(this.m_orb_runner.getORB());
        Assert.assertTrue((eventChannel != null ? 1 : 0) != 0);
        FilterFactory filterFactory = eventChannel.default_filter_factory();
        Assert.assertTrue((filterFactory != null ? 1 : 0) != 0);
        try {
            byte[] b = new byte[]{1, 43, 87, -82, 93, -70, 117, -22, -43};
            String s_filter_constraint_str = new String(b);
            Filter myFilter = filterFactory.create_filter("EXTENDED_TCL");
            EventType[] types = new EventType[]{new EventType("OpenORB", "examples")};
            ConstraintExp[] constraints = new ConstraintExp[]{new ConstraintExp(types, "$.header.fixed_header.event_name=='" + s_filter_constraint_str + "'")};
            myFilter.add_constraints(constraints);
            Assert.assertTrue((String)"We should reach this line without exceptions!", (boolean)true);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("An exception occured: " + ex), (boolean)false);
        }
    }

    private static EventChannel getEventChannel(ORB orb) {
        EventChannel eventChannel = null;
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            return null;
        }
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            return null;
        }
        Property[] initialQoS = new Property[]{};
        Property[] initialAdmin = new Property[]{};
        IntHolder channelId = new IntHolder();
        try {
            eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
        }
        catch (UnsupportedQoS ex) {
            return null;
        }
        catch (UnsupportedAdmin ex) {
            return null;
        }
        return eventChannel;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(class$org$openorb$notify$test$FilterTest == null ? (class$org$openorb$notify$test$FilterTest = FilterTest.class$("org.openorb.notify.test.FilterTest")) : class$org$openorb$notify$test$FilterTest);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FilterTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

