/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.test;

import java.io.OutputStream;
import java.util.Properties;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.StreamTarget;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CosPersistentState.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.openorb.notify.Configurator;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.Service;
import org.openorb.notify.ServiceContext;
import org.openorb.notify.test.ORBRunner;
import org.openorb.orb.core.ORB;

public class ServiceRunner {
    private static final String DEFAULT_FORMAT = "[%{priority}] (%{category}): %{message}";
    private static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String FEATURE_INITIALIZER = "org.openorb.PI.FeatureInitializerClass.";
    private ORBRunner m_orb_runner;
    private Properties m_properties = new Properties();
    private Service m_service;
    private boolean m_started;
    private boolean m_start_entered;

    public ServiceRunner() {
        ServiceRunner._setFundamentalParameters(this.m_properties);
    }

    public void addSystemProperty(String key, String value) {
        this.m_properties.setProperty(key, value);
    }

    public String getEventChannelFactoryIOR() throws ServantNotActive, WrongPolicy {
        if (!this.m_started) {
            throw new IllegalStateException("not started");
        }
        return this.m_service.getEventChannelFactoryIOR();
    }

    public void setFileDataStoreDirectory(String directory) {
        this.m_properties.setProperty("pss.File.DataStore.Directory", directory);
    }

    public void setFileDataStoreName(String filename) {
        this.m_properties.setProperty("pss.File.DataStore.Name", filename);
    }

    public void start() throws ClassNotFoundException, ContextException, NotFound, InvalidName, AdapterInactive, AdapterAlreadyExists, InvalidPolicy, ObjectAlreadyActive, ServantAlreadyActive, WrongPolicy {
        if (this.m_start_entered) {
            throw new IllegalStateException("at most once");
        }
        this.m_start_entered = true;
        this.m_orb_runner = new ORBRunner(new String[0], this.m_properties);
        org.omg.CORBA.ORB orb = this.m_orb_runner.getORB();
        POA poa = this.m_orb_runner.getRootPOA();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setORB((Object)orb);
        serviceContext.setPOA((Object)poa);
        PropertiesRepository propertiesRepository = Configurator.configurePropertiesRepository((ORB)((ORB)orb));
        serviceContext.setPropertiesRepository((Object)propertiesRepository);
        this.m_service = new Service();
        this.m_service.enableLogging(ServiceRunner._createBootstrapLogger());
        this.m_service.contextualize((Context)serviceContext);
        this.m_service.parameterize(new Parameters());
        this.m_service.initialize();
        this.m_service.start();
        this.m_orb_runner.start();
        this.m_started = true;
    }

    public void stop() throws InterruptedException {
        if (!this.m_started) {
            throw new IllegalStateException("not started");
        }
        this.m_service.stop();
        this.m_orb_runner.shutdown();
    }

    private static void _setFundamentalParameters(Properties properties) {
        properties.setProperty("openorb.ignoreXML", "true");
        properties.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.iiop.IIOPProtocolInitializer", "");
        properties.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        properties.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.poa.POAInitializer", "");
        properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.pss.Initializer", "");
    }

    private static org.apache.avalon.framework.logger.Logger _createBootstrapLogger() {
        LogKitLogger logger;
        try {
            Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
            hierarchy.setDefaultLogTarget((LogTarget)new StreamTarget((OutputStream)System.out, (Formatter)new AvalonFormatter(DEFAULT_FORMAT)));
            Logger logKitLogger = hierarchy.getLoggerFor("NotificationService");
            logKitLogger.setPriority(Priority.WARN);
            logger = new LogKitLogger(logKitLogger);
        }
        catch (Throwable e) {
            throw new CascadingRuntimeException("Unexpected exception while creating bootstrap logger.", e);
        }
        return logger;
    }
}

