/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.openorb.compiler.CompileListEntry;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.CompilerIF;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.object.IdlImport;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.pss.compiler.PsdlCompilerProperties;
import org.openorb.pss.compiler.generator.psdlToJava;
import org.openorb.pss.compiler.ir.IdlFromIR;
import org.openorb.pss.compiler.parser.PsdlParser;
import org.openorb.pss.compiler.parser.PsdlSymbole;

public class PsdlCompiler
implements CompilerHost,
CompilerIF {
    private static final String PSDL2JAVA_COMPILER = "PSDL to Java Compiler";
    private CompilerHost m_ch = null;
    private IdlCompiler m_idlcomp;
    private HashMap m_compgraph_cache = new HashMap();

    public void display_help() {
        this.m_ch.display("Usage: java org.openorb.pss.compiler.PsdlCompiler [Options] psdl-files...");
        this.m_ch.display("");
        this.m_ch.display("Options:");
        this.m_ch.display("-------");
        this.m_ch.display("  -database");
        this.m_ch.display("              Select Database persistence. Default is memory persistence.");
        this.m_ch.display("  -file");
        this.m_ch.display("              Select File persistence. Default is memory persistence.");
        this.m_ch.display("  -h, -help");
        this.m_ch.display("              Show this help message.");
        this.m_ch.display("  -noapi");
        this.m_ch.display("              Don't generate the standard API from PSDL.");
        this.m_ch.display("  -noincludedef");
        this.m_ch.display("              ???");
        this.m_ch.display("  -silence");
        this.m_ch.display("              Tells the compiler to be really quiet.");
        this.m_ch.display("  -nowrapper");
        this.m_ch.display("              Don't generate wrapper from PSDL");
        this.m_ch.display("  -wrapper <wrapper_name>");
        this.m_ch.display("              Set an external wrapper for file generation.");
    }

    public void scan_args(String[] args, CompilerProperties cp) {
        this.m_idlcomp.setM_displayBadFlag(false);
        this.m_idlcomp.scan_args(args, cp);
        PsdlCompilerProperties pcp = (PsdlCompilerProperties)cp;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-h")) {
                this.display_help();
                System.exit(1);
            } else if (args[i].equals("-silence")) {
                pcp.setM_silentMode(true);
            } else if (args[i].equals("-noincludedef")) {
                pcp.setM_default_include(false);
            } else if (args[i].equals("-help")) {
                this.display_help();
            } else if (args[i].equals("-database")) {
                pcp.setM_database_persistence(true);
            } else if (args[i].equals("-file")) {
                pcp.setM_file_persistence(true);
            } else if (args[i].equals("-noapi")) {
                pcp.setM_generate_api(false);
            } else if (args[i].equals("-nowrapper")) {
                pcp.setM_generate_wrapper(false);
            } else if (args[i].equals("-wrapper")) {
                if (++i < args.length) {
                    pcp.setM_external_wrapper(args[i]);
                    CompileListEntry cle = new CompileListEntry(args[i]);
                    pcp.getM_compileList().remove(cle);
                } else {
                    System.out.println("Error : wrapper name expected after '-wrapper'");
                    System.exit(-1);
                }
            }
            ++i;
        }
    }

    public void init_compiler(CompilerHost ch, CompilerProperties cp) {
        this.m_ch = ch;
        PsdlCompilerProperties pcp = (PsdlCompilerProperties)cp;
        this.m_idlcomp = new IdlCompiler();
        this.m_idlcomp.init_compiler((CompilerHost)this, (CompilerProperties)pcp);
        PsdlSymbole.loadPsdlSymbole();
        if (pcp.getM_default_include()) {
            this.loadCosPPS(pcp);
        }
    }

    public void compile_file(CompileListEntry cle, CompilerProperties cp) throws CompilationException {
        File fl = new File(cle.getSrcPath(), cle.getFileName());
        PsdlCompilerProperties pcp = (PsdlCompilerProperties)cp;
        pcp.setM_use_package(false);
        IdlObject CompilationGraph = null;
        if (this.m_compgraph_cache.containsKey(fl)) {
            CompilationGraph = (IdlObject)this.m_compgraph_cache.get(fl);
        } else {
            if (!pcp.getM_silentMode()) {
                this.m_ch.display("Parsing file...");
            }
            PsdlParser parser = new PsdlParser(pcp);
            if (pcp.getM_default_include()) {
                this.includePSS(pcp, parser);
            }
            try {
                CompilationGraph = parser.compile_idl(fl.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                throw new CompilationException(e.toString());
            }
            if (parser.getTotalErrors() != 0) {
                this.m_ch.display("There are errors. Compilation process stopped!");
                throw new CompilationException("There are errors. Compilation process stopped!");
            }
            this.m_compgraph_cache.put(fl, CompilationGraph);
        }
        psdlToJava toJava = new psdlToJava(pcp);
        if (pcp.getM_generate_java_data()) {
            toJava.translateData(CompilationGraph, pcp.getM_packageName());
        }
    }

    public void includePSS(PsdlCompilerProperties pcp, PsdlParser p) {
        IdlFromIR fromIR = new IdlFromIR(pcp, this.m_ch);
        fromIR.set_parser(p);
        IdlImport importPSS = new IdlImport((CompilerProperties)pcp, p.root, "::CosPersistentState");
        importPSS._map = false;
        p.root.addIdlObject((IdlObject)importPSS);
        p.ctx = p.new_compilation_context();
        try {
            p.ctx.sourceURL = new File("").getCanonicalFile().toURL();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        p.setInclude_level(1);
        fromIR.getDescriptionFromIR("::CosPersistentState", p.root);
        p.setInclude_level(0);
    }

    public void loadCosPPS(CompilerProperties cp) {
        cp.getM_importLink().add("CosPersistentState:CosPersistentState.idl");
    }

    public void display(String s) {
        System.out.println(s);
    }

    public CompilerProperties createEmptyProperties() {
        return new PsdlCompilerProperties();
    }

    public void execute_compiler(CompilerHost ch, CompilerProperties cp) {
        if (!cp.getM_silentMode()) {
            ch.display("PSDL to Java Compiler, Copyright (c) 2002-2005 The Community OpenORB");
        }
    }

    public static void main(String[] args) {
        PsdlCompiler psdlcomp = new PsdlCompiler();
        IdlCompiler.genCompilerExec((CompilerIF)psdlcomp, (CompilerHost)psdlcomp, (String[])args);
    }
}

