/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.compiler.generator;

import java.io.File;
import java.io.PrintWriter;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlTypeDef;
import org.openorb.pss.compiler.PsdlCompilerProperties;
import org.openorb.pss.compiler.object.PsdlAbstractRef;
import org.openorb.pss.compiler.object.PsdlAbstractStorageHome;
import org.openorb.pss.compiler.object.PsdlAbstractStorageType;
import org.openorb.pss.compiler.object.PsdlCatalog;
import org.openorb.pss.compiler.object.PsdlFactory;
import org.openorb.pss.compiler.object.PsdlKey;
import org.openorb.pss.compiler.object.PsdlLocalOp;
import org.openorb.pss.compiler.object.PsdlProvides;
import org.openorb.pss.compiler.object.PsdlState;
import org.openorb.pss.compiler.reflect.psdlCatalog;
import org.openorb.pss.compiler.reflect.psdlStorageHome;
import org.openorb.pss.compiler.reflect.psdlStorageType;
import org.openorb.pss.connector.database.DatabaseWrapper;
import org.openorb.pss.connector.file.FileWrapper;
import org.openorb.pss.connector.memory.MemoryWrapper;
import org.openorb.pss.wrapper.PsdlWrapper;

public class psdlToJava
extends IdlToJava {
    private PsdlWrapper wrap;
    private PsdlCompilerProperties m_pcp;

    public psdlToJava(PsdlCompilerProperties psp) {
        super((CompilerProperties)psp);
        this.m_pcp = psp;
        if (this.m_pcp.getM_external_wrapper() != null) {
            try {
                Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(this.m_pcp.getM_external_wrapper());
                Object obj = clz.newInstance();
                this.wrap = (PsdlWrapper)obj;
            }
            catch (Exception ex) {
                System.out.println("Fatal error : unable to find the external wrapper !!!");
                System.exit(-1);
            }
        } else {
            this.wrap = this.m_pcp.getM_file_persistence() ? new FileWrapper(this.m_pcp) : (this.m_pcp.getM_database_persistence() ? new DatabaseWrapper(this.m_pcp) : new MemoryWrapper(this.m_pcp));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void translate_comment_section(PrintWriter output, String description, IdlObject obj) {
        switch (obj.kind()) {
            case 201: 
            case 206: {
                int i = 0;
                while (i < description.length()) {
                    if (description.charAt(i) == '\n') {
                        if (i == description.length() - 1) {
                            output.println("");
                            return;
                        }
                        output.println("");
                        output.print("\t");
                        output.print(" * ");
                    } else {
                        output.print(description.charAt(i));
                    }
                    ++i;
                }
                break;
            }
        }
        super.translate_comment_section(output, description, obj);
    }

    public void javadoc(PrintWriter output, IdlObject obj) {
        switch (obj.kind()) {
            case 201: 
            case 206: {
                IdlComment comment = obj.getComment();
                String description = null;
                if (comment == null) break;
                description = comment.get_description();
                output.print("\t");
                output.println("/**");
                output.print("\t");
                output.print(" * ");
                this.translate_comment_section(output, description, obj);
                IdlCommentSection[] sections = comment.get_sections();
                int i = 0;
                while (i < sections.length) {
                    switch (sections[i].kind().value()) {
                        case 0: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @author ");
                            break;
                        }
                        case 6: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @deprecated ");
                            break;
                        }
                        case 1: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @exception ");
                            break;
                        }
                        case 4: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @return ");
                            break;
                        }
                        case 3: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @param ");
                            break;
                        }
                        case 5: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @see ");
                            break;
                        }
                        case 2: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @version ");
                            break;
                        }
                        case 7: {
                            if (obj.kind() == 17 || obj.kind() == 16) {
                                output.print("\t");
                            }
                            output.print(" * @" + sections[i].get_title() + " ");
                        }
                    }
                    description = sections[i].get_description();
                    this.translate_comment_section(output, description, obj);
                    ++i;
                }
                output.print("\t");
                output.println(" */");
                break;
            }
            default: {
                super.javadoc(output, obj);
            }
        }
    }

    protected boolean isRefType(IdlObject obj) {
        return this.final_kind(obj) == 207;
    }

    protected IdlObject getRefType(IdlObject obj) {
        return this.final_type(obj);
    }

    protected boolean isImmutable(IdlObject obj) {
        switch (this.final_kind(obj)) {
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void translate_abstract_storagetype_state(PsdlState state, PrintWriter output) {
        if (state.hasComment()) {
            this.javadoc(output, state);
        } else {
            output.println("\t//");
            output.println("\t// State " + state.name());
            output.println("\t//");
        }
        if (this.isRefType(state.type())) {
            IdlObject obj = this.getRefType(state.type());
            output.print("\tpublic ");
            this.translate_type(obj.type(), output);
            output.print(" " + state.name() + "();");
            output.println("");
            output.print("\tpublic ");
            this.translate_type(state.type(), output);
            output.print(" " + state.name() + "( org.omg.CosPersistentState.YieldRef yr );");
            output.println("");
            if (!state.readonly()) {
                if (state.hasComment()) {
                    this.javadoc(output, state);
                } else {
                    output.println("\t//");
                    output.println("\t// State " + state.name());
                    output.println("\t//");
                }
                output.print("\tpublic void " + state.name() + "( ");
                this.translate_type(obj.type(), output);
                output.println(" arg );");
                output.print("\tpublic void " + state.name() + "( ");
                this.translate_type(state.type(), output);
                output.println(" arg );");
            }
        } else if (this.isImmutable(state.type())) {
            output.print("\tpublic ");
            this.translate_type(state.type(), output);
            output.print(" " + state.name() + "();");
            output.println("");
            if (!state.readonly()) {
                if (state.hasComment()) {
                    this.javadoc(output, state);
                } else {
                    output.println("\t//");
                    output.println("\t// State " + state.name());
                    output.println("\t//");
                }
                output.print("\tpublic void " + state.name() + "( ");
                this.translate_type(state.type(), output);
                output.println(" arg );");
            }
        } else {
            output.print("\tpublic ");
            this.translate_type(state.type(), output);
            output.print(" " + state.name() + "();");
            output.println("");
            output.print("\tpublic ");
            this.translate_type(state.type(), output);
            output.print(" " + state.name() + "( org.omg.CosPersistentState.ForUpdate fu );");
            output.println("");
            if (!state.readonly()) {
                if (state.hasComment()) {
                    this.javadoc(output, state);
                } else {
                    output.println("\t//");
                    output.println("\t// State " + state.name());
                    output.println("\t//");
                }
                output.print("\tpublic void " + state.name() + "( ");
                this.translate_type(state.type(), output);
                output.println(" arg );");
            }
        }
        output.println("");
    }

    public void translate_abstract_storagetype_local_op(PsdlLocalOp op, PrintWriter output) {
        boolean someParams = false;
        if (op.hasComment()) {
            this.javadoc(output, (IdlObject)op);
        } else {
            output.println("\t//");
            output.println("\t// Local operation " + op.name());
            output.println("\t//");
        }
        output.print("\tpublic ");
        op.reset();
        this.translate_type(op.current(), output);
        output.print(" " + op.name() + "(");
        op.next();
        if (!op.end() && op.current().kind() == 19) {
            someParams = true;
            while (!op.end()) {
                op.current().reset();
                this.translate_parameter(op.current().current(), output, ((IdlParam)op.current()).param_attr());
                output.print(" " + op.current().name());
                op.next();
                if (op.end()) continue;
                if (op.current().kind() != 19) break;
                output.print(", ");
            }
        }
        output.print(")");
        if (!op.end() && op.current().kind() == 20) {
            output.println("");
            output.print("\t\tthrows ");
            IdlRaises r = (IdlRaises)op.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println(";");
        output.println("");
    }

    public void translate_abstract_storagetype_content(PsdlAbstractStorageType abs, PrintWriter output) {
        abs.reset();
        while (!abs.end()) {
            switch (abs.current().kind()) {
                case 201: {
                    this.translate_abstract_storagetype_local_op((PsdlLocalOp)abs.current(), output);
                    break;
                }
                case 206: {
                    this.translate_abstract_storagetype_state((PsdlState)abs.current(), output);
                    break;
                }
                default: {
                    System.out.println("warning number 1 : " + abs.current().kind());
                }
            }
            abs.next();
        }
    }

    public void translate_abstract_storagetype(IdlObject obj, File writeInto) {
        int i;
        PsdlAbstractStorageType abs = (PsdlAbstractStorageType)obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        this.addDescriptiveHeader(output, abs);
        IdlObject[] inheritance = abs.getInheritance();
        if (inheritance.length == 0) {
            output.println("public interface " + abs.name() + " extends org.omg.CosPersistentState.StorageObject");
        } else {
            output.print("public interface " + abs.name() + " extends ");
            i = 0;
            while (i < inheritance.length) {
                output.print(this.fullname(inheritance[i]));
                if (i + 1 < inheritance.length) {
                    output.print(", ");
                }
                ++i;
            }
            output.println("");
        }
        output.println("{");
        this.translate_abstract_storagetype_content(abs, output);
        output.println("}");
        output.close();
        output = this.newFile(writeInto, obj.name() + "Ref");
        this.addDescriptiveHeader(output, abs);
        if (inheritance.length == 0) {
            output.println("public interface " + abs.name() + "Ref extends org.omg.CosPersistentState.StorageObjectRef");
        } else {
            output.print("public interface " + abs.name() + "Ref extends ");
            i = 0;
            while (i < inheritance.length) {
                output.print(this.fullname(inheritance[i]) + "Ref");
                if (i + 1 < inheritance.length) {
                    output.print(", ");
                }
                ++i;
            }
            output.println("");
        }
        output.println("{ }");
        output.close();
        this.write_holder(abs, writeInto);
    }

    public void translate_key_to_equivalent_operations(PsdlKey key, IdlObject obj, PsdlAbstractStorageHome abh) {
        IdlOp op1 = new IdlOp(obj);
        op1.name("find_by_" + key.name());
        op1.type(abh.manage());
        op1.attach_comment(key.getComment());
        IdlParam param = null;
        PsdlState state = null;
        key.reset();
        while (!key.end()) {
            param = new IdlParam((IdlObject)op1);
            param.param_attr(0);
            state = (PsdlState)key.current();
            param.name(state.name());
            param.type(state.type());
            op1.addIdlObject((IdlObject)param);
            key.next();
        }
        IdlRaises raises1 = new IdlRaises((IdlObject)op1);
        raises1.addIdlObject(obj.returnVisibleObject("CosPersistentState::NotFound", false));
        op1.addIdlObject((IdlObject)raises1);
        obj.addIdlObject((IdlObject)op1);
        IdlOp op2 = new IdlOp(obj);
        op2.attach_comment(key.getComment());
        op2.name("find_ref_by_" + key.name());
        PsdlAbstractRef ref = new PsdlAbstractRef((IdlObject)op2);
        ref.addIdlObject(abh.manage());
        op2.type((IdlObject)ref);
        key.reset();
        while (!key.end()) {
            param = new IdlParam((IdlObject)op2);
            param.param_attr(0);
            state = (PsdlState)key.current();
            param.name(state.name());
            param.type(state.type());
            op2.addIdlObject((IdlObject)param);
            key.next();
        }
        obj.addIdlObject((IdlObject)op2);
    }

    public void translate_factory_to_equivalent_operations(PsdlFactory factory, IdlObject obj, PsdlAbstractStorageHome abh) {
        IdlOp op = new IdlOp(obj);
        op.attach_comment(factory.getComment());
        op.name(factory.name());
        op.type(abh.manage());
        IdlParam param = null;
        PsdlState state = null;
        factory.reset();
        while (!factory.end()) {
            param = new IdlParam((IdlObject)op);
            param.param_attr(0);
            state = (PsdlState)factory.current();
            param.name(state.name());
            param.type(state.type());
            op.addIdlObject((IdlObject)param);
            factory.next();
        }
        obj.addIdlObject((IdlObject)op);
    }

    public void translate_provides_to_equivalent_operations(PsdlProvides provides, IdlObject obj) {
        IdlOp op = new IdlOp(obj);
        op.attach_comment(obj.getComment());
        op.name("get_" + provides.name());
        op.type(provides.type());
        obj.addIdlObject((IdlObject)op);
    }

    public void translate_abstract_storagehome(IdlObject obj, File writeInto) {
        PsdlAbstractStorageHome abh = (PsdlAbstractStorageHome)obj;
        IdlInterface equ = new IdlInterface(obj.upper());
        equ.local_interface(true);
        equ.name(obj.name());
        equ.attach_comment(abh.getComment());
        PsdlAbstractStorageHome[] in = abh.inheritances();
        if (in.length != 0) {
            IdlInterface in_itf = null;
            int i = 0;
            while (i < in.length) {
                in_itf = new IdlInterface(in[i].upper());
                in_itf.name(in[i].name());
                in_itf.local_interface(true);
                equ.addInheritance((IdlObject)in_itf);
                ++i;
            }
        } else {
            equ.addInheritance(obj.returnVisibleObject("CosPersistentState::StorageHomeBase", false));
        }
        abh.reset();
        while (!abh.end()) {
            switch (abh.current().kind()) {
                case 201: {
                    equ.addIdlObject(abh.current());
                    break;
                }
                case 208: {
                    this.translate_key_to_equivalent_operations((PsdlKey)abh.current(), (IdlObject)equ, abh);
                    break;
                }
                case 209: {
                    this.translate_factory_to_equivalent_operations((PsdlFactory)abh.current(), (IdlObject)equ, abh);
                }
            }
            abh.next();
        }
        this.translate_interface((IdlObject)equ, writeInto);
    }

    public void translate_catalog(IdlObject obj, File writeInto) {
        PsdlCatalog cat = (PsdlCatalog)obj;
        IdlInterface equ = new IdlInterface(obj.upper());
        equ.attach_comment(cat.getComment());
        equ.local_interface(true);
        equ.name(obj.name());
        PsdlCatalog[] in = cat.inheritance();
        if (in.length != 0) {
            IdlInterface in_itf = null;
            int i = 0;
            while (i < in.length) {
                in_itf = new IdlInterface(in[i].upper());
                in_itf.name(in[i].name());
                in_itf.local_interface(true);
                equ.addInheritance((IdlObject)in_itf);
                ++i;
            }
        } else {
            equ.addInheritance(obj.returnVisibleObject("CosPersistentState::CatalogBase", false));
        }
        cat.reset();
        while (!cat.end()) {
            switch (cat.current().kind()) {
                case 201: {
                    equ.addIdlObject(cat.current());
                    break;
                }
                case 216: {
                    this.translate_provides_to_equivalent_operations((PsdlProvides)cat.current(), (IdlObject)equ);
                }
            }
            cat.next();
        }
        this.translate_interface((IdlObject)equ, writeInto);
    }

    public void addDescriptiveHeader(PrintWriter output, IdlObject obj) {
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (this.m_pcp.getM_use_package()) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        switch (obj.kind()) {
            case 7: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Constant definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 2: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Enum definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 3: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Struct definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 4: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Union definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 14: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Exception definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 15: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Interface definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 27: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Value box definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 28: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Value Type definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
                break;
            }
            case 204: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Abstract StorageType definition : " + obj.name());
                output.println("//");
                output.println("// @author PSDL Compiler");
                output.println("//");
            }
        }
    }

    public void translate_parameter(IdlObject obj, PrintWriter output, int attr) {
        switch (obj.kind()) {
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                if (attr == 0) {
                    output.print(this.fullname(obj));
                    break;
                }
                output.print(this.fullname(obj) + "Holder");
                break;
            }
            case 207: {
                obj.reset();
                if (attr == 0) {
                    output.print(this.fullname(obj.current()) + "Ref");
                    break;
                }
                output.print(this.fullname(obj.current()) + "RefHolder");
                break;
            }
            case 10: {
                this.translate_parameter(((IdlIdent)obj).internalObject(), output, attr);
                break;
            }
            default: {
                super.translate_parameter(obj, output, attr);
            }
        }
    }

    public void translate_typedef(IdlObject obj, File writeInto) {
        PrintWriter output = null;
        obj.reset();
        block0 : switch (obj.current().kind()) {
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 210: 
            case 212: 
            case 213: {
                break;
            }
            case 217: {
                output = this.newFile(writeInto, obj.name() + "Holder");
                this.write_holder_for_sequence_ref(obj, output);
                output.close();
                break;
            }
            case 24: {
                obj.current().reset();
                if (this.isRefType(obj.current().current())) {
                    output = this.newFile(writeInto, obj.name() + "Holder");
                    this.write_holder_for_sequence_ref(obj, output);
                    output.close();
                    break;
                }
                super.translate_typedef(obj, writeInto);
                break;
            }
            default: {
                if (obj.current().kind() == 10) {
                    IdlObject internal = ((IdlIdent)obj.current()).internalObject();
                    switch (internal.kind()) {
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 210: 
                        case 212: 
                        case 213: {
                            break block0;
                        }
                    }
                    super.translate_typedef(obj, writeInto);
                    break;
                }
                super.translate_typedef(obj, writeInto);
            }
        }
    }

    public void translate_type(IdlObject obj, PrintWriter output) {
        switch (obj.kind()) {
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                output.print(this.fullname(obj));
                break;
            }
            case 207: {
                obj.reset();
                output.print(this.fullname(obj.current()) + "Ref");
                break;
            }
            case 217: {
                obj.reset();
                obj.current().reset();
                output.print(this.fullname(obj.current().current()) + "Ref []");
                break;
            }
            default: {
                super.translate_type(obj, output);
            }
        }
    }

    protected void write_default_holder_body(PrintWriter output) {
        output.println("\tpublic void _read( org.omg.CORBA.portable.InputStream istream )");
        output.println("\t{");
        output.println("\t\tthrow new org.omg.CORBA.NO_IMPLEMENT();");
        output.println("\t}");
        output.println("");
        output.println("\tpublic void _write( org.omg.CORBA.portable.OutputStream ostream )");
        output.println("\t{");
        output.println("\t\tthrow new org.omg.CORBA.NO_IMPLEMENT();");
        output.println("\t}");
        output.println("");
        output.println("\tpublic org.omg.CORBA.TypeCode _type()");
        output.println("\t{");
        output.println("\t\tthrow new org.omg.CORBA.NO_IMPLEMENT();");
        output.println("\t}");
        output.println("");
    }

    public void write_holder_for_abstract_storagetype(IdlObject obj, PrintWriter output) {
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (this.m_pcp.getM_use_package()) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        output.println("//");
        output.println("// Holder class for : " + obj.name());
        output.println("//");
        output.println("// @author PSDL Compiler");
        output.println("//");
        output.println("public class " + obj.name() + "Holder implements org.omg.CORBA.portable.Streamable");
        output.println("{");
        output.println("\t//");
        output.println("\t// Internal " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic ");
        this.translate_type(obj, output);
        output.println(" value;");
        output.println("");
        output.println("\t//");
        output.println("\t// Default constructor");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "Holder()");
        output.println("\t{ }");
        output.println("");
        output.println("\t//");
        output.println("\t// Constructor with value initialisation");
        output.println("\t// @param initial the initial value");
        output.println("\t//");
        output.print("\tpublic " + obj.name() + "Holder( ");
        this.translate_type(obj, output);
        output.println(" initial )");
        output.println("\t{");
        output.println("\t\tvalue = initial;");
        output.println("\t}");
        output.println("");
        this.write_default_holder_body(output);
        output.println("}");
    }

    public void write_holder_for_abstract_storagetype_ref(IdlObject obj, PrintWriter output) {
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (this.m_pcp.getM_use_package()) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        output.println("//");
        output.println("// Holder class for : " + obj.name());
        output.println("//");
        output.println("// @author PSDL Compiler");
        output.println("//");
        output.println("public class " + obj.name() + "RefHolder implements org.omg.CORBA.portable.Streamable");
        output.println("{");
        output.println("\t//");
        output.println("\t// Internal " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic ");
        this.translate_type(obj, output);
        output.println("Ref value;");
        output.println("");
        output.println("\t//");
        output.println("\t// Default constructor");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "RefHolder()");
        output.println("\t{ }");
        output.println("");
        output.println("\t//");
        output.println("\t// Constructor with value initialisation");
        output.println("\t// @param initial the initial value");
        output.println("\t//");
        output.print("\tpublic " + obj.name() + "RefHolder( ");
        this.translate_type(obj, output);
        output.println("Ref initial )");
        output.println("\t{");
        output.println("\t\tvalue = initial;");
        output.println("\t}");
        output.println("");
        this.write_default_holder_body(output);
        output.println("}");
    }

    public void write_holder_for_sequence_ref(IdlObject obj, PrintWriter output) {
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (this.m_pcp.getM_use_package()) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        output.println("//");
        output.println("// Holder class for : " + obj.name());
        output.println("//");
        output.println("// @author PSDL Compiler");
        output.println("//");
        output.println("public class " + obj.name() + "Holder implements org.omg.CORBA.portable.Streamable");
        output.println("{");
        output.println("\t//");
        output.println("\t// Internal " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic ");
        this.translate_type(obj, output);
        output.println(" value;");
        output.println("");
        output.println("\t//");
        output.println("\t// Default constructor");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "Holder()");
        output.println("\t{ }");
        output.println("");
        output.println("\t//");
        output.println("\t// Constructor with value initialisation");
        output.println("\t// @param initial the initial value");
        output.println("\t//");
        output.print("\tpublic " + obj.name() + "Holder( ");
        this.translate_type(obj, output);
        output.println(" initial )");
        output.println("\t{");
        output.println("\t\tvalue = initial;");
        output.println("\t}");
        output.println("");
        this.write_default_holder_body(output);
        output.println("}");
    }

    public void write_holder(IdlObject obj, File writeInto) {
        if (this.contains_ast(obj)) {
            PrintWriter output = this.newFile(writeInto, obj.name() + "Holder");
            this.write_holder_for_abstract_storagetype(obj, output);
            output.close();
            if (!this.contains_seq(obj)) {
                output = this.newFile(writeInto, obj.name() + "RefHolder");
                this.write_holder_for_abstract_storagetype_ref(obj, output);
                output.close();
            }
            return;
        }
        block0 : switch (obj.kind()) {
            case 204: {
                PrintWriter output = this.newFile(writeInto, obj.name() + "Holder");
                this.write_holder_for_abstract_storagetype(obj, output);
                output.close();
                output = this.newFile(writeInto, obj.name() + "RefHolder");
                this.write_holder_for_abstract_storagetype_ref(obj, output);
                output.close();
                break;
            }
            default: {
                switch (this.ref_type(obj)) {
                    case 217: {
                        PrintWriter output = this.newFile(writeInto, obj.name() + "Holder");
                        this.write_holder_for_sequence_ref(obj, output);
                        output.close();
                        break block0;
                    }
                }
                super.write_holder(obj, writeInto);
            }
        }
    }

    public void write_helper(IdlObject obj, File writeInto) {
        if (this.contains_ref(obj)) {
            return;
        }
        if (this.contains_ast(obj)) {
            return;
        }
        super.write_helper(obj, writeInto);
    }

    private boolean contains_ref(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.contains_ref(((IdlIdent)obj).internalObject());
            }
            case 207: 
            case 214: 
            case 217: {
                return true;
            }
            case 9: {
                obj.reset();
                return this.contains_ref(obj.current());
            }
            case 13: {
                return this.contains_ref(((IdlTypeDef)obj).type());
            }
        }
        return false;
    }

    private boolean contains_ast(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.contains_ast(((IdlIdent)obj).internalObject());
            }
            case 204: {
                return true;
            }
            case 9: {
                obj.reset();
                return this.contains_ast(obj.current());
            }
            case 13: {
                return this.contains_ast(((IdlTypeDef)obj).type());
            }
        }
        return false;
    }

    private boolean contains_seq(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.contains_seq(((IdlIdent)obj).internalObject());
            }
            case 9: {
                return true;
            }
            case 13: {
                return this.contains_seq(((IdlTypeDef)obj).type());
            }
        }
        return false;
    }

    private int ref_type(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.ref_type(((IdlIdent)obj).internalObject());
            }
            case 217: {
                return 217;
            }
            case 207: {
                return 207;
            }
            case 9: {
                obj.reset();
                int rt = this.ref_type(obj.current());
                switch (rt) {
                    case 207: 
                    case 217: {
                        return 217;
                    }
                }
                return rt;
            }
            case 13: {
                return this.ref_type(((IdlTypeDef)obj).type());
            }
        }
        return -1;
    }

    public void translate_object_content(IdlObject obj, File writeInto, int translateType) {
        switch (obj.current().kind()) {
            case 204: {
                if (!this.m_pcp.getM_generate_api() || translateType != 0) break;
                this.translate_abstract_storagetype(obj.current(), writeInto);
                break;
            }
            case 205: {
                break;
            }
            case 202: {
                if (!this.m_pcp.getM_generate_api() || translateType != 0) break;
                this.translate_abstract_storagehome(obj.current(), writeInto);
                break;
            }
            case 203: {
                break;
            }
            case 212: {
                if (!this.m_pcp.getM_generate_wrapper() || translateType != 0) break;
                this.wrap.map_storagetype(writeInto, (psdlStorageType)obj.current());
                break;
            }
            case 210: {
                if (!this.m_pcp.getM_generate_wrapper() || translateType != 0) break;
                this.wrap.map_storagehome(writeInto, (psdlStorageHome)obj.current());
                break;
            }
            case 200: {
                if (!this.m_pcp.getM_generate_wrapper() || translateType != 0) break;
                this.translate_catalog(obj.current(), writeInto);
                this.wrap.map_catalog(writeInto, (psdlCatalog)obj.current());
                break;
            }
            case 1: {
                super.translate_object_content(obj, writeInto, translateType);
                break;
            }
            default: {
                if (!this.m_pcp.getM_generate_api()) break;
                super.translate_object_content(obj, writeInto, translateType);
            }
        }
    }

    public void translate_object(IdlObject obj, File writeInto, int translateType) {
        obj.reset();
        while (!obj.end()) {
            File tmpInto = writeInto;
            if (!obj.current().included()) {
                String old_pkg = this.current_pkg;
                if (this.m_pcp.getM_usePrefix() && obj.current().getPrefix() != null && obj.kind() == 0) {
                    tmpInto = translateType == 0 ? this.createPrefixDirectories(obj.current().getPrefix(), writeInto) : this.getPrefixDirectories(obj.current().getPrefix(), writeInto);
                    this.addToPkg(obj, this.inversedPrefix(obj.current().getPrefix()));
                }
                this.translate_object_content(obj, tmpInto, translateType);
                this.current_pkg = old_pkg;
            }
            obj.next();
        }
    }
}

