/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.compiler.ir;

import java.util.Hashtable;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.IdlParser;
import org.openorb.pss.compiler.PsdlCompilerProperties;

public class IdlFromIR {
    private Hashtable m_imported = new Hashtable();
    private IdlParser m_parser;
    private PsdlCompilerProperties m_pcp;
    private CompilerHost m_ch;

    public IdlFromIR(PsdlCompilerProperties pcp, CompilerHost ch) {
        this.m_pcp = pcp;
        this.m_ch = ch;
    }

    public void set_parser(IdlParser parser) {
        this.m_parser = parser;
    }

    private boolean isAlreadyImported(String scope_name) {
        if (!scope_name.startsWith("::")) {
            scope_name = "::" + scope_name;
        }
        return this.m_imported.get(scope_name) != null;
    }

    private boolean importFromIDLFile(String container_name) {
        String idl_file = this.getIDLFileName(container_name);
        if (idl_file != null) {
            this.m_parser.include_idl_file(idl_file);
            return true;
        }
        return false;
    }

    private String getLinkContainerName(String link) {
        return link.substring(0, link.indexOf(":"));
    }

    private String getLinkFileName(String link) {
        return link.substring(link.indexOf(":") + 1, link.length());
    }

    private void addAsImported(String scope_name) {
        if (!scope_name.startsWith("::")) {
            scope_name = "::" + scope_name;
        }
        this.m_imported.put(scope_name, scope_name);
    }

    private String getIDLFileName(String container_name) {
        int i = 0;
        while (i < this.m_pcp.getM_importLink().size()) {
            if (this.getLinkContainerName((String)this.m_pcp.getM_importLink().elementAt(i)).equalsIgnoreCase(container_name)) {
                return this.getLinkFileName((String)this.m_pcp.getM_importLink().elementAt(i));
            }
            ++i;
        }
        return null;
    }

    public boolean checkFromImportFromFile(String container_name) {
        if (!container_name.startsWith("::")) {
            return false;
        }
        if ((container_name = container_name.substring(2)).indexOf("::") != -1) {
            return false;
        }
        if (this.importFromIDLFile(container_name)) {
            this.addAsImported(container_name);
            return true;
        }
        return false;
    }

    public void getDescriptionFromIR(String scope_name, IdlObject current_scope) {
        if (this.isAlreadyImported(scope_name)) {
            return;
        }
        if (this.checkFromImportFromFile(scope_name)) {
            return;
        }
        throw new RuntimeException("IdlFromIR: An unexpected condition occured!");
    }
}

