/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.Connector;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObjectRef;
import org.openorb.pss.connector.ExtendedCatalog;
import org.openorb.pss.connector.Iterator;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.database.DatabaseConnector;
import org.openorb.pss.connector.database.DatabaseIterator;
import org.openorb.pss.connector.database.PIDFactory;
import org.openorb.pss.connector.database.PersistentObjectHome;

public abstract class DatabaseCatalog
extends LocalObject
implements CatalogBase,
ExtendedCatalog {
    protected DatabaseConnector _connector;
    protected Hashtable _home_from_storage_home_name = new Hashtable();
    protected Hashtable _home_from_pid = new Hashtable();
    private short _access;
    private Parameter[] _parameters;

    public Connector connector() {
        return this._connector;
    }

    public void setCatalogInfo(DatabaseConnector connector, short access, Parameter[] parameters) {
        this._connector = connector;
        this._access = access;
        this._parameters = parameters;
    }

    public short access_mode() {
        return this._access;
    }

    public Parameter[] parameters() {
        return this._parameters;
    }

    public StorageHomeBase find_storage_home(String storage_home_id) throws NotFound {
        StorageHomeBase home = (StorageHomeBase)this._home_from_storage_home_name.get(storage_home_id);
        if (home == null) {
            Class clz = this._connector.get_storage_home_factory(storage_home_id);
            if (clz == null) {
                throw new NotFound();
            }
            try {
                Object obj = clz.newInstance();
                this.register_home_incarnation(obj, storage_home_id);
                return (StorageHomeBase)obj;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
            }
        }
        return home;
    }

    public Object find_by_pid(byte[] the_pid) throws NotFound {
        StorageHomeBase home = null;
        byte[] catalog_pid = PIDFactory.pid_to_catalog_pid(the_pid);
        byte[] short_pid = PIDFactory.pid_to_short_pid(the_pid);
        home = (StorageHomeBase)this._home_from_pid.get(new String(catalog_pid));
        if (home != null) {
            Object object = home.find_by_short_pid(short_pid);
            if (object == null) {
                throw new NotFound();
            }
            return object;
        }
        throw new NotFound();
    }

    public StorageObjectRef find_ref_by_pid(byte[] the_pid) throws NotFound {
        StorageHomeBase home = null;
        byte[] catalog_pid = PIDFactory.pid_to_catalog_pid(the_pid);
        byte[] short_pid = PIDFactory.pid_to_short_pid(the_pid);
        home = (StorageHomeBase)this._home_from_pid.get(new String(catalog_pid));
        if (home != null) {
            return ((PersistentObjectHome)((Object)home)).create_reference(the_pid);
        }
        throw new NotFound();
    }

    public byte[][] find_all(StorageHomeBase home) {
        PID home_pid = ((PersistentObjectHome)((Object)home)).getPID();
        PID[] list = this.find_pids(home_pid);
        byte[][] all = new byte[list.length][];
        int i = 0;
        while (i < list.length) {
            all[i] = list[i].value();
            ++i;
        }
        return all;
    }

    public Iterator iterator(StorageHomeBase home) {
        return new DatabaseIterator(home, this);
    }

    public void clean(StorageHomeBase home) {
    }

    public abstract void flush();

    public abstract void refresh();

    public abstract void free_all();

    public abstract void close();

    protected abstract void register_home_incarnation(Object var1, String var2);

    public abstract StorageHomeBase find_home_base(PID var1);

    public abstract PID[] find_pids(PID var1);

    public abstract void destroy(StorageHomeBase var1);
}

