/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.GIOP.Version;
import org.openorb.orb.core.ORB;
import org.openorb.orb.iiop.CDRInputStream;
import org.openorb.orb.iiop.CDROutputStream;
import org.openorb.orb.io.MarshalBuffer;
import org.openorb.orb.io.StorageBuffer;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.database.DatabaseCatalog;
import org.openorb.pss.connector.database.KeyBag;
import org.openorb.pss.connector.database.PIDFactory;
import org.openorb.pss.connector.database.PersistentObjectHome;
import org.openorb.pss.connector.database.PersistentRef;
import org.openorb.pss.util.debug;

public class DatabaseUtil {
    static /* synthetic */ Class class$org$omg$CORBA$ORB;

    public static void truncArray(Object[] src, Object[] tgt, int index) {
        if (index == 0) {
            System.arraycopy(src, 1, tgt, 0, tgt.length);
        } else {
            System.arraycopy(src, 0, tgt, 0, index);
            System.arraycopy(src, index + 1, tgt, index, src.length - (index + 1));
        }
    }

    public static KeyBag[] keys(int size) {
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
        KeyBag[] keys = new KeyBag[size];
        int i = 0;
        while (i < keys.length) {
            keys[i] = new KeyBag();
            keys[i].value = DatabaseUtil.getCDROutputStream();
            ++i;
        }
        return keys;
    }

    public static void marshalRef(Object ref, OutputStream output) {
        if (ref == null) {
            debug.print("Marshal a NULL reference");
            output.write_long(0);
        } else {
            debug.print("Marshal a reference");
            StorageObjectRef r = (StorageObjectRef)ref;
            byte[] pid = r.get_pid();
            output.write_long(pid.length);
            output.write_octet_array(pid, 0, pid.length);
        }
    }

    public static StorageObjectRef unmarshalRef(Object ref, InputStream input, StorageHomeBase hbase) {
        int size = input.read_long();
        if (size == 0) {
            debug.print("Unmarshal a NULL reference");
            return null;
        }
        byte[] pid = new byte[size];
        input.read_octet_array(pid, 0, size);
        if (ref != null) {
            ((PersistentRef)ref).update(pid);
        } else {
            try {
                debug.print("Unmarshal a reference");
                PID Pid = PIDFactory.pid_byte_to_pid(pid);
                StorageHomeBase home = null;
                CatalogBase cat = hbase.get_catalog();
                home = ((DatabaseCatalog)cat).find_home_base(Pid);
                ref = ((PersistentObjectHome)((Object)home)).create_reference(pid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (StorageObjectRef)ref;
    }

    public static OutputStream[] outputArray(int size) {
        OutputStream[] array = new OutputStream[size];
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
        int i = 0;
        while (i < array.length) {
            array[i] = DatabaseUtil.getCDROutputStream();
            ++i;
        }
        return array;
    }

    public static void flatOutput(OutputStream output, OutputStream[] outputs) {
        byte[] buffer = null;
        int i = 0;
        while (i < outputs.length) {
            CDROutputStream output_stream = (CDROutputStream)outputs[i];
            buffer = DatabaseUtil.getBuffer(output_stream);
            output.write_long(buffer.length);
            output.write_octet_array(buffer, 0, buffer.length);
            ++i;
        }
    }

    public static InputStream[] multipleInput(InputStream input, int nb) {
        InputStream[] inputs = new InputStream[nb];
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
        int size = 0;
        byte[] buffer = null;
        CDROutputStream output = null;
        int i = 0;
        while (i < nb) {
            size = input.read_long();
            buffer = new byte[size];
            input.read_octet_array(buffer, 0, size);
            output = DatabaseUtil.getCDROutputStream();
            output.write_octet_array(buffer, 0, size);
            CDROutputStream output_stream = output;
            buffer = DatabaseUtil.getBuffer(output_stream);
            inputs[i] = DatabaseUtil.getCDRInputStream(buffer);
            ++i;
        }
        return inputs;
    }

    public static CDROutputStream getCDROutputStream() {
        CDROutputStream output;
        MarshalBuffer marshal = new MarshalBuffer();
        Version version = new Version(1, 2);
        OpenORBInitInfo info = (OpenORBInitInfo)PIDFactory.info;
        ORB orb = info.orb();
        try {
            Object[] args = new Object[3];
            Class[] cargs = new Class[3];
            args[0] = orb;
            cargs[0] = class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = DatabaseUtil.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB;
            args[1] = version;
            args[2] = marshal;
            output = (CDROutputStream)orb.getLoader().constructClass("iiop.CDROutputStreamClass", "org.openorb.orb.iiop.CDROutputStream", args, cargs);
        }
        catch (Exception ex) {
            throw new INITIALIZE("Unable to create CDROutputStream class");
        }
        return output;
    }

    public static CDRInputStream getCDRInputStream(byte[] data) {
        CDRInputStream input;
        StorageBuffer buffer = new StorageBuffer(data, 0, data.length);
        Version version = new Version(1, 2);
        OpenORBInitInfo info = (OpenORBInitInfo)PIDFactory.info;
        ORB orb = info.orb();
        try {
            Object[] args = new Object[4];
            Class[] cargs = new Class[4];
            args[0] = orb;
            cargs[0] = class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = DatabaseUtil.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB;
            args[1] = new Boolean(true);
            cargs[1] = Boolean.TYPE;
            args[2] = version;
            args[3] = buffer;
            input = (CDRInputStream)orb.getLoader().constructClass("iiop.CDRInputStreamClass", "org.openorb.orb.iiop.CDRInputStream", args, cargs);
        }
        catch (Exception ex) {
            throw new INITIALIZE("Unable to create CDROutputStream class");
        }
        return input;
    }

    public static byte[] getBuffer(CDROutputStream output) {
        StorageBuffer buffer = output.getMarshalBuffer().lastFragment();
        return buffer.linearize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

