/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.GIOP.Version;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.core.ORB;
import org.openorb.orb.iiop.CDRInputStream;
import org.openorb.orb.iiop.CDROutputStream;
import org.openorb.orb.io.MarshalBuffer;
import org.openorb.orb.io.StorageBuffer;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.DataEntry;
import org.openorb.pss.connector.file.DataManager;
import org.openorb.pss.connector.file.FileCatalog;
import org.openorb.pss.connector.file.FileConnector;
import org.openorb.pss.connector.file.FilePID;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PIDFactory;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;
import org.openorb.util.ORBUtils;

public class FileSession
extends FileCatalog
implements Session {
    private File _datastore;
    protected String _extension = "";
    protected Hashtable _home_datastores = new Hashtable();
    protected static Hashtable _datastores = new Hashtable();
    private ORBInitInfo _info;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;

    public FileSession() {
        this._info = PIDFactory.info;
        this._home_datastores = new Hashtable();
    }

    public FileSession(ORBInitInfo info) {
        this._info = info;
        this._home_datastores = new Hashtable();
    }

    public void setBaseInfo(FileConnector connector, short access, Parameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].name.equals("HomeExtension")) {
                this._extension = parameters[i].val.extract_string();
            }
            ++i;
        }
        this.setCatalogInfo(connector, access, parameters);
    }

    public synchronized DataManager getDataManager(String storage_home_name) {
        DataManager manager = null;
        manager = (DataManager)_datastores.get(storage_home_name + this.getFileStorageName());
        if (manager == null) {
            manager = new DataManager(storage_home_name, this.getFileStorageName(), this._info);
            _datastores.put(storage_home_name + this.getFileStorageName(), manager);
        } else {
            manager.share();
        }
        return manager;
    }

    public synchronized PID createHomePID(String storage_home_name) {
        int high = storage_home_name.hashCode();
        int low = this.getFileStorageName().hashCode();
        return new FilePID(((long)high << 32) + (long)low, 0L, this._info);
    }

    public synchronized PID createPID(PID home_pid, long index) {
        return new FilePID(home_pid.catalog_value(), index, this._info);
    }

    protected String getFileStorageName() {
        ORBLoader cfg = ((OpenORBInitInfo)this._info).orb().getLoader();
        String dirName = cfg.getStringProperty("PSS.File.DataStore.Directory", null);
        String name = cfg.getStringProperty("PSS.File.DataStore.Name", null);
        try {
            File datastoreDir = ORBUtils.getTemporaryDir((String)dirName, (String)name);
            return datastoreDir.getPath();
        }
        catch (IOException ex) {
            throw new CascadingRuntimeException("failed to create datastore directory", (Throwable)ex);
        }
    }

    protected synchronized void invalidate_entry(DataManager manager, PID pid) {
        manager.lock_flush(true);
        manager.invalidate_entry(pid);
        manager.lock_flush(false);
    }

    protected synchronized DataEntry find_entry(DataManager manager, PID pid) throws NotFoundException {
        DataEntry entry = manager.read_entry(pid);
        return entry;
    }

    public synchronized void delete(PID home_pid, PID type_pid) {
        DataManager manager = this.lookup_manager_from_home_pid(home_pid);
        this.invalidate_entry(manager, type_pid);
    }

    public synchronized boolean stored(PID home_pid, PID type_pid) {
        DataManager manager = this.lookup_manager_from_home_pid(home_pid);
        try {
            DataEntry entry = this.find_entry(manager, type_pid);
            if (entry == null) {
                return false;
            }
        }
        catch (NotFoundException ex) {
            return false;
        }
        return true;
    }

    public synchronized InputStream entry(PID home_pid, PID type_pid) throws NotFoundException {
        DataManager manager = this.lookup_manager_from_home_pid(home_pid);
        DataEntry entry = this.find_entry(manager, type_pid);
        if (entry == null) {
            throw new NotFoundException("Could not locate an entry.");
        }
        return this.getCDRInputStream(entry.data);
    }

    public synchronized OutputStream create_new_entry(PID home_pid, PID type_pid) {
        return this.getCDROutputStream();
    }

    public synchronized void entry(PID home_pid, PID type_pid, OutputStream output) {
        DataManager manager = this.lookup_manager_from_home_pid(home_pid);
        DataEntry new_entry = new DataEntry();
        new_entry.valid = true;
        new_entry.short_pid = type_pid.short_value();
        StorageBuffer buffer = ((CDROutputStream)output).getMarshalBuffer().lastFragment();
        new_entry.data = buffer.linearize();
        this.delete(home_pid, type_pid);
        manager.write_entry(new_entry);
    }

    public void write_entry(DataManager manager, DataEntry entry) {
        manager.write_entry(entry);
    }

    protected synchronized void register_home_incarnation(Object obj, String storage_home_name) {
        PersistentObjectHome home = (PersistentObjectHome)obj;
        PID pid = this.createHomePID(storage_home_name);
        home.setPersistentLinks(this, pid);
        this._home_incarnations.put(storage_home_name, obj);
        this._home_datastores.put(pid, this.getDataManager(storage_home_name));
    }

    private synchronized DataManager lookup_manager_from_home_pid(PID home_pid) {
        return (DataManager)this._home_datastores.get(home_pid);
    }

    public void clean(StorageHomeBase home) {
        this.flush();
        PID pid = ((PersistentObjectHome)((Object)home)).getPID();
        DataManager dataMgr = (DataManager)this._home_datastores.get(pid);
        if (dataMgr != null) {
            dataMgr.close();
            this._home_datastores.remove(pid);
            this._home_datastores.put(pid, this.getDataManager(dataMgr.home()));
        }
    }

    public void destroy(StorageHomeBase home) {
        this.flush();
        PID pid = ((PersistentObjectHome)((Object)home)).getPID();
        DataManager dataMgr = (DataManager)this._home_datastores.get(pid);
        if (dataMgr != null) {
            dataMgr.close();
            this._home_datastores.remove(pid);
            dataMgr.destroy();
        }
    }

    public synchronized void flush() {
        Enumeration enumeration = this._home_datastores.elements();
        DataManager manager = null;
        while (enumeration.hasMoreElements()) {
            manager = (DataManager)enumeration.nextElement();
            manager.flush();
        }
    }

    public synchronized void refresh() {
        Enumeration enumeration = this._home_incarnations.elements();
        PersistentObjectHome home = null;
        while (enumeration.hasMoreElements()) {
            home = (PersistentObjectHome)enumeration.nextElement();
            home.refreshAll();
        }
    }

    public synchronized void free_all() {
        Enumeration enumeration = this._home_datastores.elements();
        DataManager manager = null;
        while (enumeration.hasMoreElements()) {
            manager = (DataManager)enumeration.nextElement();
            manager.free_all();
        }
    }

    public synchronized void close() {
        Enumeration enumeration = this._home_datastores.elements();
        DataManager manager = null;
        while (enumeration.hasMoreElements()) {
            manager = (DataManager)enumeration.nextElement();
            manager.close();
        }
        if (!manager.shared()) {
            _datastores.remove(manager.key());
        }
    }

    public synchronized StorageObject incarnate(StorageHomeBase home_base, byte[] storage_type_pid, String storage_type_id) throws NotFoundException {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            String error = "Unable to locate the storage type factory for: ";
            throw new NotFoundException("Unable to locate the storage type factory for: " + storage_type_id);
        }
        try {
            Object obj = clz.newInstance();
            PID pid = PIDFactory.short_pid_to_pid(storage_type_pid, ((PersistentObjectHome)((Object)home_base)).getPID());
            ((PersistentObject)obj).setPersistentLinks(pid, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            ((PersistentObjectHome)((Object)home_base)).refresh((PersistentObject)obj);
            return (StorageObject)obj;
        }
        catch (PersistenceException ex) {
            if (ex.minor == 1) {
                throw new NotFoundException();
            }
            throw new PersistenceException(0, CompletionStatus.COMPLETED_NO, (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new PersistenceException(11, CompletionStatus.COMPLETED_NO, ex);
        }
    }

    public synchronized StorageObject create_object(StorageHomeBase home_base, String storage_type_id) {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        DataManager manager = this.lookup_manager_from_home_pid(((PersistentObjectHome)((Object)home_base)).getPID());
        long freeIndex = manager.nextFreeID();
        if (clz == null) {
            String error = "Storage type factory returned a null class";
            throw new PersistenceException("Storage type factory returned a null class");
        }
        try {
            Object obj = clz.newInstance();
            PID pid = this.createPID(((PersistentObjectHome)((Object)home_base)).getPID(), freeIndex);
            ((PersistentObject)obj).setPersistentLinks(pid, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PersistenceException(11, CompletionStatus.COMPLETED_NO, ex);
        }
    }

    public synchronized StorageObject create_empty_object(StorageHomeBase home_base, String storage_type_id) {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new PersistenceException("Storage type factory returned a null class");
        }
        try {
            Object obj = clz.newInstance();
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            throw new PersistenceException("Unexpected exception while creating storage object.", 11, CompletionStatus.COMPLETED_NO, ex);
        }
    }

    public synchronized StorageObject create_embedded_object(StorageHomeBase home_base, String storage_type_id) {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new PersistenceException("Storage type factory returned a null class");
        }
        try {
            Object obj = clz.newInstance();
            ((PersistentObject)obj).setPersistentLinks(null, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            throw new PersistenceException("Unexpected exception while creating embedded storage object.", 11, CompletionStatus.COMPLETED_NO, ex);
        }
    }

    public StorageHomeBase find_home_base(PID pid) {
        PID p = null;
        Enumeration enumeration = this._home_datastores.keys();
        while (enumeration.hasMoreElements()) {
            p = (PID)enumeration.nextElement();
            if (!p.is_same_catalog(pid.catalog_value())) continue;
            DataManager mgr = (DataManager)this._home_datastores.get(p);
            return (StorageHomeBase)this._home_incarnations.get(mgr.home());
        }
        return null;
    }

    public Enumeration getSequentialAccess(PID home_pid) {
        DataManager manager = (DataManager)this._home_datastores.get(home_pid);
        return manager.content();
    }

    private CDROutputStream getCDROutputStream() {
        CDROutputStream output;
        MarshalBuffer marshal = new MarshalBuffer();
        Version version = new Version(1, 2);
        ORB orb = ((OpenORBInitInfo)this._info).orb();
        try {
            Object[] args = new Object[3];
            Class[] cargs = new Class[3];
            args[0] = orb;
            cargs[0] = class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = FileSession.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB;
            args[1] = version;
            args[2] = marshal;
            output = (CDROutputStream)orb.getLoader().constructClass("iiop.CDROutputStreamClass", "org.openorb.orb.iiop.CDROutputStream", args, cargs);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to create CDROutputStream class.", ex);
        }
        return output;
    }

    private CDRInputStream getCDRInputStream(byte[] data) {
        CDRInputStream input;
        StorageBuffer buffer = new StorageBuffer(data, 0, data.length);
        Version version = new Version(1, 2);
        ORB orb = ((OpenORBInitInfo)this._info).orb();
        try {
            Object[] args = new Object[4];
            Class[] cargs = new Class[4];
            args[0] = orb;
            cargs[0] = class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = FileSession.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB;
            args[1] = new Boolean(true);
            cargs[1] = Boolean.TYPE;
            args[2] = version;
            args[3] = buffer;
            input = (CDRInputStream)orb.getLoader().constructClass("iiop.CDRInputStreamClass", "org.openorb.iiop.CDRInputStream", args, cargs);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to create CDROutputStream class.", ex);
        }
        return input;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

