/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.memory;

import java.util.Enumeration;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryCatalog;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.MemoryConnector;
import org.openorb.pss.connector.memory.MemoryPID;
import org.openorb.pss.connector.memory.NotFoundException;
import org.openorb.pss.connector.memory.PIDFactory;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;

public class MemorySession
extends MemoryCatalog
implements Session,
MemoryCatalogBase {
    private ORBInitInfo _info;

    public MemorySession() {
        this._info = PIDFactory.info;
    }

    public MemorySession(ORBInitInfo info) {
        this._info = info;
    }

    public void setBaseInfo(MemoryConnector connector, short access, Parameter[] parameters) {
        this.setCatalogInfo(connector, access, parameters);
    }

    public synchronized PID createHomePID(String storage_home_name) {
        int high = storage_home_name.hashCode();
        return new MemoryPID(high, 0L, this._info);
    }

    public synchronized PID createPID(PID home_pid, long index) {
        return new MemoryPID(home_pid.catalog_value(), index, this._info);
    }

    public void delete(PID home_pid, PID type_pid) {
    }

    public boolean stored(PID home_pid, PID type_pid) {
        return false;
    }

    protected synchronized void register_home_incarnation(Object obj, String storage_home_name) {
        PersistentObjectHome home = (PersistentObjectHome)obj;
        PID pid = this.createHomePID(storage_home_name);
        home.setPersistentLinks(this, pid);
        this._home_incarnations.put(pid, obj);
        this._home_pid.put(storage_home_name, pid);
    }

    public void flush() {
    }

    public void refresh() {
    }

    public void free_all() {
    }

    public void close() {
    }

    public synchronized StorageObject incarnate(StorageHomeBase home_base, byte[] storage_type_pid, String storage_type_id) throws NotFoundException {
        return null;
    }

    public synchronized StorageObject create_object(StorageHomeBase home_base, String storage_type_id) {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new PERSIST_STORE();
        }
        try {
            Object obj = clz.newInstance();
            PID pid = this.createPID(((PersistentObjectHome)((Object)home_base)).getPID(), PIDFactory.getFreeID());
            ((PersistentObject)obj).setPersistentLinks(pid, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized StorageObject create_embedded_object(StorageHomeBase home_base, String storage_type_id) {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new PERSIST_STORE();
        }
        try {
            Object obj = clz.newInstance();
            ((PersistentObject)obj).setPersistentLinks(null, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
        }
    }

    public StorageHomeBase find_home_base(PID pid) {
        PID p = null;
        Enumeration enumeration = this._home_incarnations.keys();
        while (enumeration.hasMoreElements()) {
            p = (PID)enumeration.nextElement();
            if (!p.is_same_catalog(pid.catalog_value())) continue;
            return (StorageHomeBase)this._home_incarnations.get(p);
        }
        return null;
    }
}

