/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.file.basic.second;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileCatalogBase;
import org.openorb.pss.connector.file.FileKeyBag;
import org.openorb.pss.connector.file.FileUtil;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;
import org.openorb.pss.examples.file.basic.second.CarRef;
import org.openorb.pss.examples.file.basic.second.Person;
import org.openorb.pss.examples.file.basic.second.PersonBase;
import org.openorb.pss.examples.file.basic.second.PersonBaseRef;
import org.openorb.pss.examples.file.basic.second.PersonHome;
import org.openorb.pss.examples.file.basic.second.PersonRef;

public class PersonHomeBase
extends LocalObject
implements PersonHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
        }
        StorageObject obj = null;
        try {
            obj = ((FileCatalogBase)this._catalog).incarnate((StorageHomeBase)this, short_pid, "PSDL:org/openorb/pss/examples/file/basic/second/PersonBase:1.0");
        }
        catch (NotFoundException ex) {
            throw new NotFound();
        }
        this.register_type_incarnation(obj);
        return obj;
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public PersonBase _create(String name) {
        PersonBase obj = (PersonBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:org/openorb/pss/examples/file/basic/second/PersonBase:1.0");
        this.register_type_incarnation(obj);
        obj.name(name);
        return obj;
    }

    public PersonBase _create(CarRef car) {
        PersonBase obj = (PersonBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:org/openorb/pss/examples/file/basic/second/PersonBase:1.0");
        this.register_type_incarnation(obj);
        obj.car(car);
        return obj;
    }

    public PersonBaseRef _create(String name, YieldRef yr) {
        PersonBase obj = this._create(name);
        return new PersonBaseRef(obj.get_pid(), this._catalog);
    }

    public PersonBaseRef _create(CarRef car, YieldRef yr) {
        PersonBase obj = this._create(car);
        return new PersonBaseRef(obj.get_pid(), this._catalog);
    }

    public Person create(String name, CarRef car) {
        PersonBase obj = (PersonBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:org/openorb/pss/examples/file/basic/second/PersonBase:1.0");
        this.register_type_incarnation(obj);
        obj.name(name);
        obj.car(car);
        return obj;
    }

    public Person find_by_name(String name) throws NotFound {
        Enumeration _enum = ((FileCatalogBase)this._catalog).getSequentialAccess(this._pid);
        FileKeyBag _bag = null;
        CarRef _tmp_car = null;
        while (_enum.hasMoreElements()) {
            _bag = (FileKeyBag)_enum.nextElement();
            if (_bag == null) break;
            String _tmp_name = _bag.input.read_string();
            _tmp_car = (CarRef)FileUtil.unmarshalRef(_tmp_car, (InputStream)_bag.input, (StorageHomeBase)this);
            if (!name.equals(_tmp_name)) continue;
            return (Person)this.find_by_short_pid(_bag.short_pid);
        }
        throw new NotFound();
    }

    public PersonRef find_ref_by_name(String name) {
        Enumeration _enum = ((FileCatalogBase)this._catalog).getSequentialAccess(this._pid);
        FileKeyBag _bag = null;
        CarRef _tmp_car = null;
        while (_enum.hasMoreElements()) {
            _bag = (FileKeyBag)_enum.nextElement();
            if (_bag == null) break;
            String _tmp_name = _bag.input.read_string();
            _tmp_car = (CarRef)FileUtil.unmarshalRef(_tmp_car, (InputStream)_bag.input, (StorageHomeBase)this);
            if (!name.equals(_tmp_name)) continue;
            return new PersonBaseRef(_bag.short_pid, this);
        }
        return null;
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new PersonBaseRef(pid, this._catalog);
    }

    public StorageObject create_object() {
        return ((FileCatalogBase)this._catalog).create_empty_object((StorageHomeBase)this, "PSDL:org/openorb/pss/examples/file/basic/second/PersonBase:1.0");
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((FileCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((FileCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public void refresh(PersistentObject storage_type) {
        try {
            InputStream input = ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID());
            storage_type.read(input);
        }
        catch (NotFoundException ex) {
            throw new PersistenceException(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public void refreshAll() {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                this.refresh((PersistentObject)it.next());
            }
        }
    }

    public void flush(PersistentObject storage_type) {
        if (this._catalog.access_mode() != 1) {
            throw new PersistenceException("Bad access mode.", 6, CompletionStatus.COMPLETED_NO);
        }
        OutputStream output = ((FileCatalogBase)this._catalog).create_new_entry(this._pid, storage_type.getPID());
        storage_type.write(output);
        ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID(), output);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

