/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.memory.transactional.second;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.LocalObject;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.NotFoundException;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;
import org.openorb.pss.examples.memory.transactional.second.Car;
import org.openorb.pss.examples.memory.transactional.second.CarBase;
import org.openorb.pss.examples.memory.transactional.second.CarBaseRef;
import org.openorb.pss.examples.memory.transactional.second.CarHome;
import org.openorb.pss.examples.memory.transactional.second.CarRef;
import org.openorb.pss.examples.memory.transactional.second.Color;

public class CarHomeBase
extends LocalObject
implements CarHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
            throw new NotFound();
        }
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public CarBase _create(String trademark, String name, Color color) {
        CarBase obj = (CarBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:org/openorb/pss/examples/memory/transactional/second/CarBase:1.0");
        this.register_type_incarnation(obj);
        obj.trademark(trademark);
        obj.name(name);
        obj.color(color);
        return obj;
    }

    public CarBase _create() {
        CarBase obj = (CarBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:org/openorb/pss/examples/memory/transactional/second/CarBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public CarBaseRef _create(String trademark, String name, Color color, YieldRef yr) {
        CarBase obj = this._create(trademark, name, color);
        return new CarBaseRef(obj.get_pid(), this._catalog);
    }

    public CarBaseRef _create(YieldRef yr) {
        CarBase obj = this._create();
        return new CarBaseRef(obj.get_pid(), this._catalog);
    }

    public Car create(String trademark, String name, Color color) {
        CarBase obj = (CarBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:org/openorb/pss/examples/memory/transactional/second/CarBase:1.0");
        this.register_type_incarnation(obj);
        obj.trademark(trademark);
        obj.name(name);
        obj.color(color);
        return obj;
    }

    public Car find_by_carName(String name) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                Car obj = (Car)it.next();
                String _tmp_name = obj.name();
                if (!name.equals(_tmp_name)) continue;
                Car car = obj;
                return car;
            }
        }
        throw new NotFound();
    }

    public CarRef find_ref_by_carName(String name) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                Car obj = (Car)it.next();
                String _tmp_name = obj.name();
                if (!name.equals(_tmp_name)) continue;
                CarBaseRef carBaseRef = new CarBaseRef(obj.get_short_pid(), this);
                return carBaseRef;
            }
        }
        return null;
    }

    public Object[] get_incarnations() {
        return this._incarnations.toArray();
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new CarBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((MemoryCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((MemoryCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

