/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CosTransactions.ControlPOA;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.ots.Admin.Manager;
import org.openorb.ots.Impl.Coordinator;
import org.openorb.ots.Impl.SubCoordinator;
import org.openorb.ots.Impl.SubTransCoordinator;
import org.openorb.ots.Impl.SubTransTerminator;
import org.openorb.ots.Impl.Terminator;
import org.openorb.ots.Impl.TimeOutControl;
import org.openorb.ots.Impl.TransactionFactory;
import org.openorb.ots.Impl.XID;

public class Control
extends ControlPOA {
    private org.omg.CosTransactions.Terminator m_terminator;
    private SubTransTerminator m_sub_terminator_impl;
    private org.omg.CosTransactions.Coordinator m_coordinator;
    private Coordinator m_coordinator_impl;
    private POA m_poa;
    private Manager m_manager;
    private Logger m_logger;

    public SubTransTerminator getSubTransTerminator() {
        return this.m_sub_terminator_impl;
    }

    public Coordinator getCoordinator() {
        return this.m_coordinator_impl;
    }

    public Control(int time_out, Manager manager, PropagationContext ctx, TransactionFactory factory, POA poa, POA recovery_poa, Logger logger) {
        Terminator terminatorImpl = null;
        this.m_manager = manager;
        this.m_poa = poa;
        this.m_logger = logger;
        try {
            XID xid;
            if (ctx == null) {
                xid = new XID();
                this.m_coordinator_impl = new Coordinator(manager, xid, time_out, poa, recovery_poa, this.getLogger());
                terminatorImpl = new Terminator(poa, this.m_coordinator_impl, this.getLogger());
            } else {
                xid = new XID(ctx, true);
                this.m_coordinator_impl = new SubCoordinator(this.m_manager, xid, time_out, ctx.current.coord, poa, recovery_poa, this.getLogger());
                this.m_terminator = null;
            }
            byte[] id = poa.activate_object((Servant)this.m_coordinator_impl);
            this.m_coordinator = CoordinatorHelper.narrow(poa.id_to_reference(id));
            if (terminatorImpl != null) {
                id = poa.activate_object((Servant)terminatorImpl);
                this.m_terminator = TerminatorHelper.narrow(poa.id_to_reference(id));
            }
            this.m_coordinator_impl.setTerminator(this.m_terminator);
        }
        catch (Exception ex) {
            this.getLogger().error("Problem while initializing ots Control", (Throwable)ex);
        }
        if (time_out != 0 && this.m_terminator != null) {
            TimeOutControl control = new TimeOutControl(terminatorImpl, time_out, this.getLogger());
            control.setDaemon(true);
            control.start();
        }
    }

    public Control(int time_out, Manager manager, XID parent_xid, POA poa, TransIdentity[] parents, Logger logger) {
        this.m_manager = manager;
        this.m_poa = poa;
        this.m_logger = logger;
        try {
            XID xid = new XID(parent_xid);
            this.m_coordinator_impl = new SubTransCoordinator(this.m_manager, time_out, xid, parents, poa, this.getLogger());
            this.m_sub_terminator_impl = new SubTransTerminator(poa, this.m_coordinator_impl);
            byte[] id = poa.activate_object((Servant)this.m_coordinator_impl);
            this.m_coordinator = CoordinatorHelper.narrow(poa.id_to_reference(id));
            id = poa.activate_object((Servant)this.m_sub_terminator_impl);
            this.m_terminator = TerminatorHelper.narrow(poa.id_to_reference(id));
            this.m_coordinator_impl.setTerminator(this.m_terminator);
        }
        catch (Exception ex) {
            this.getLogger().error("Problem while initializing ots Control for subtransaction", (Throwable)ex);
        }
    }

    public org.omg.CosTransactions.Terminator get_terminator() throws Unavailable {
        if (this.m_terminator == null) {
            throw new Unavailable();
        }
        return this.m_terminator;
    }

    public org.omg.CosTransactions.Coordinator get_coordinator() throws Unavailable {
        return this.m_coordinator;
    }

    public void update() {
        this.m_coordinator_impl.updatePropagationContext(this);
    }

    public void removeItself() {
        this.m_manager.getControls().remove(this);
        try {
            this.m_poa.deactivate_object(this.m_poa.servant_to_id((Servant)this));
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy ex) {
        }
        catch (ServantNotActive servantNotActive) {
            // empty catch block
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

