/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.TerminatorPOA;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.ots.Admin.Manager;
import org.openorb.ots.Impl.Coordinator;
import org.openorb.ots.Impl.TimeOutControl;
import org.openorb.ots.ManagerCallbackPackage.HeuristicKind;
import org.openorb.ots.log.Writer;

public class Terminator
extends TerminatorPOA {
    private Coordinator m_coordinator;
    private TimeOutControl m_time_ctrl;
    private Vector m_prepared;
    private Vector m_heuristic;
    private boolean m_disable_remove;
    private POA m_poa;
    private Logger m_logger;

    public Terminator(POA poa, Coordinator coordinator, Logger logger) {
        this.m_coordinator = coordinator;
        this.m_prepared = new Vector();
        this.m_heuristic = new Vector();
        this.m_disable_remove = false;
        this.m_poa = poa;
        this.m_logger = logger;
    }

    public synchronized void commit(boolean report_heuristics) throws HeuristicMixed, HeuristicHazard {
        boolean heuristic_mixed = false;
        boolean heuristic_rollback = false;
        boolean heuristic_hazard = false;
        boolean rolledback = false;
        switch (this.m_coordinator.get_status().value()) {
            case 0: {
                break;
            }
            case 4: {
                throw new TRANSACTION_ROLLEDBACK();
            }
            case 1: {
                this.rollback();
                throw new TRANSACTION_ROLLEDBACK();
            }
            default: {
                throw new INVALID_TRANSACTION();
            }
        }
        if (this.m_time_ctrl != null) {
            this.m_time_ctrl.finish();
        }
        this.m_coordinator.commit_sub_transactions();
        Resource[] resources = this.m_coordinator.resources();
        this.m_heuristic.removeAllElements();
        Writer.getOut().commit_begin(this.m_coordinator.getXID());
        if (resources.length == 1) {
            try {
                this.proceed_commit_one_phase(resources[0]);
            }
            catch (HeuristicHazard ex) {
                this.m_coordinator.setStatus(Status.StatusUnknown);
                heuristic_hazard = true;
                this.m_heuristic.addElement(resources[0]);
            }
        } else {
            BooleanHolder heuristicMixedHolder = new BooleanHolder(false);
            BooleanHolder heuristicHazardHolder = new BooleanHolder(false);
            Vote vote = this.proceed_prepare(resources, heuristicMixedHolder, heuristicHazardHolder);
            if (heuristicMixedHolder.value) {
                heuristic_mixed = true;
                heuristicMixedHolder.value = false;
            }
            if (heuristicHazardHolder.value) {
                heuristic_hazard = true;
                heuristicHazardHolder.value = false;
            }
            switch (vote.value()) {
                case 0: {
                    this.proceed_commit(resources, heuristicMixedHolder, heuristicHazardHolder);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.proceed_rollback_after_prepare();
                    rolledback = true;
                }
            }
        }
        Writer.getOut().commit_end(this.m_coordinator.getXID(), this.m_coordinator.get_status());
        if (!this.m_disable_remove) {
            this.proceed_forget();
            this.removeItself();
        }
        if (rolledback) {
            Manager.notifyRollback(this.m_coordinator.getXID());
            throw new TRANSACTION_ROLLEDBACK();
        }
        if (report_heuristics) {
            if (heuristic_rollback) {
                Manager.notifyHeuristic(this.m_coordinator.getXID(), HeuristicKind.rollback);
            }
            if (heuristic_mixed) {
                Manager.notifyHeuristic(this.m_coordinator.getXID(), HeuristicKind.mixed);
            }
            if (heuristic_hazard) {
                Manager.notifyHeuristic(this.m_coordinator.getXID(), HeuristicKind.hazard);
            }
            if (heuristic_rollback || heuristic_mixed) {
                throw new HeuristicMixed();
            }
            if (heuristic_hazard) {
                throw new HeuristicHazard();
            }
        }
        Manager.notifyCommit(this.m_coordinator.getXID());
    }

    public synchronized void rollback() {
        this.m_heuristic.removeAllElements();
        switch (this.m_coordinator.get_status().value()) {
            case 0: 
            case 1: {
                break;
            }
            case 4: {
                return;
            }
            default: {
                throw new INVALID_TRANSACTION();
            }
        }
        if (this.m_time_ctrl != null) {
            this.m_time_ctrl.finish();
        }
        this.m_coordinator.rollback_sub_transactions();
        Writer.getOut().rollback_begin(this.m_coordinator.getXID());
        this.m_coordinator.synchronize();
        this.proceed_rollback();
        if (!this.m_disable_remove) {
            this.proceed_forget();
            this.removeItself();
        }
        Writer.getOut().rollback_end(this.m_coordinator.getXID(), this.m_coordinator.get_status());
        Manager.notifyRollback(this.m_coordinator.getXID());
    }

    public synchronized void proceed_commit_one_phase(Resource res) throws HeuristicHazard {
        this.m_coordinator.synchronize();
        this.m_coordinator.setStatus(Status.StatusCommitting);
        try {
            Writer.getOut().commit_one_phase_begin(this.m_coordinator.getXID(), res);
            res.commit_one_phase();
            Writer.getOut().commit_resource(this.m_coordinator.getXID(), res);
            this.m_coordinator.setStatus(Status.StatusCommitted);
        }
        catch (COMM_FAILURE ex) {
            this.m_coordinator.setStatus(Status.StatusRolledBack);
        }
        catch (OBJECT_NOT_EXIST ex) {
            this.m_coordinator.setStatus(Status.StatusRolledBack);
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            this.m_coordinator.setStatus(Status.StatusRolledBack);
        }
        this.m_coordinator.desynchronize();
    }

    public synchronized Vote proceed_prepare(Resource[] resources, BooleanHolder heuristicMixedHolder, BooleanHolder heuristicHazardHolder) {
        boolean rollback = false;
        Vote global_vote = Vote.VoteReadOnly;
        this.m_coordinator.synchronize();
        this.m_coordinator.setStatus(Status.StatusPreparing);
        Writer.getOut().prepare_begin(this.m_coordinator.getXID());
        if (resources.length == 0) {
            this.m_coordinator.setStatus(Status.StatusCommitted);
            this.m_coordinator.desynchronize();
            return global_vote;
        }
        this.m_prepared.removeAllElements();
        int i = 0;
        while (i < resources.length) {
            if (rollback) {
                try {
                    resources[i].rollback();
                    Writer.getOut().rollback_resource(this.m_coordinator.getXID(), resources[i]);
                }
                catch (HeuristicCommit ex) {
                }
                catch (HeuristicMixed ex) {
                    heuristicMixedHolder.value = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (HeuristicHazard ex) {
                    heuristicHazardHolder.value = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (COMM_FAILURE ex) {
                }
                catch (OBJECT_NOT_EXIST ex) {}
            } else {
                try {
                    switch (this.vote(resources[i]).value()) {
                        case 0: {
                            global_vote = Vote.VoteCommit;
                            this.m_prepared.addElement(resources[i]);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 1: {
                            global_vote = Vote.VoteRollback;
                            rollback = true;
                        }
                    }
                }
                catch (HeuristicHazard ex) {
                    global_vote = Vote.VoteRollback;
                    heuristicHazardHolder.value = true;
                    rollback = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (HeuristicMixed ex) {
                    global_vote = Vote.VoteRollback;
                    heuristicMixedHolder.value = true;
                    rollback = true;
                    this.m_heuristic.addElement(resources[i]);
                }
            }
            ++i;
        }
        if (global_vote.value() == 0) {
            this.m_coordinator.setStatus(Status.StatusPrepared);
        }
        if (global_vote.value() == 2) {
            this.m_coordinator.setStatus(Status.StatusCommitted);
            this.m_coordinator.desynchronize();
        }
        Writer.getOut().prepare_end(this.m_coordinator.getXID(), this.m_coordinator.get_status(), global_vote);
        return global_vote;
    }

    public synchronized void proceed_commit(Resource[] resources, BooleanHolder heuristicMixedHolder, BooleanHolder heuristicHazardHolder) {
        boolean error = false;
        boolean committed = false;
        boolean rollbacked = false;
        Resource res = null;
        this.m_coordinator.setStatus(Status.StatusCommitting);
        int i = 0;
        while (i < this.m_prepared.size()) {
            res = (Resource)this.m_prepared.elementAt(i);
            if (error && !committed) {
                try {
                    res.rollback();
                    rollbacked = true;
                    Writer.getOut().rollback_resource(this.m_coordinator.getXID(), res);
                }
                catch (HeuristicCommit ex) {
                    if (!rollbacked) {
                        committed = true;
                    }
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (HeuristicHazard ex) {
                    heuristicHazardHolder.value = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (HeuristicMixed ex) {
                    heuristicMixedHolder.value = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (COMM_FAILURE ex) {
                }
                catch (OBJECT_NOT_EXIST ex) {}
            } else {
                try {
                    res.commit();
                    committed = true;
                    Writer.getOut().commit_resource(this.m_coordinator.getXID(), res);
                }
                catch (NotPrepared ex) {
                    error = true;
                }
                catch (HeuristicRollback ex) {
                    error = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (HeuristicMixed ex) {
                    error = true;
                    heuristicMixedHolder.value = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (HeuristicHazard ex) {
                    error = true;
                    heuristicHazardHolder.value = true;
                    this.m_heuristic.addElement(resources[i]);
                }
                catch (COMM_FAILURE ex) {
                    error = true;
                }
                catch (OBJECT_NOT_EXIST ex) {
                    error = true;
                }
            }
            ++i;
        }
        if (!error) {
            this.m_coordinator.setStatus(Status.StatusCommitted);
            this.m_coordinator.desynchronize();
            return;
        }
        if (rollbacked) {
            this.m_coordinator.setStatus(Status.StatusRolledBack);
            this.m_coordinator.desynchronize();
            Writer.getOut().rollback_end(this.m_coordinator.getXID(), this.m_coordinator.get_status());
            throw new TRANSACTION_ROLLEDBACK();
        }
        this.m_coordinator.setStatus(Status.StatusUnknown);
        this.m_coordinator.desynchronize();
    }

    public synchronized void proceed_rollback_after_prepare() {
        Resource res = null;
        this.m_coordinator.setStatus(Status.StatusRollingBack);
        int i = 0;
        while (i < this.m_prepared.size()) {
            try {
                res = (Resource)this.m_prepared.elementAt(i);
                res.rollback();
                Writer.getOut().rollback_resource(this.m_coordinator.getXID(), res);
            }
            catch (HeuristicCommit ex) {
                this.m_heuristic.addElement(res);
            }
            catch (HeuristicMixed ex) {
                this.m_heuristic.addElement(res);
            }
            catch (HeuristicHazard ex) {
                this.m_heuristic.addElement(res);
            }
            catch (COMM_FAILURE ex) {
            }
            catch (OBJECT_NOT_EXIST ex) {
                // empty catch block
            }
            ++i;
        }
        this.m_coordinator.setStatus(Status.StatusRolledBack);
        this.m_coordinator.desynchronize();
    }

    public synchronized void proceed_rollback() {
        this.m_coordinator.setStatus(Status.StatusRollingBack);
        Resource[] resources = this.m_coordinator.resources();
        int i = 0;
        while (i < resources.length) {
            try {
                resources[i].rollback();
                Writer.getOut().rollback_resource(this.m_coordinator.getXID(), resources[i]);
            }
            catch (HeuristicCommit ex) {
                this.m_heuristic.addElement(resources[i]);
            }
            catch (HeuristicMixed ex) {
                this.m_heuristic.addElement(resources[i]);
            }
            catch (HeuristicHazard ex) {
                this.m_heuristic.addElement(resources[i]);
            }
            catch (COMM_FAILURE ex) {
            }
            catch (OBJECT_NOT_EXIST ex) {
                // empty catch block
            }
            ++i;
        }
        this.m_coordinator.setStatus(Status.StatusRolledBack);
        this.m_coordinator.desynchronize();
    }

    public synchronized void proceed_forget() {
        Resource res = null;
        int i = 0;
        while (i < this.m_heuristic.size()) {
            res = (Resource)this.m_heuristic.elementAt(i);
            try {
                res.forget();
            }
            catch (COMM_FAILURE ex) {
            }
            catch (OBJECT_NOT_EXIST ex) {
                // empty catch block
            }
            ++i;
        }
        this.m_heuristic.removeAllElements();
    }

    private synchronized Vote vote(Resource r) throws HeuristicMixed, HeuristicHazard {
        Vote vote = null;
        try {
            vote = r.prepare();
            Writer.getOut().prepare_resource(this.m_coordinator.getXID(), r, vote);
            return vote;
        }
        catch (COMM_FAILURE ex) {
            return Vote.VoteRollback;
        }
        catch (OBJECT_NOT_EXIST ex) {
            return Vote.VoteRollback;
        }
        catch (Exception ex) {
            this.getLogger().error("An exception occurred during preparation of commit - rolling back transaction", (Throwable)ex);
            return Vote.VoteRollback;
        }
    }

    public void setTimeOutControl(TimeOutControl time) {
        this.m_time_ctrl = time;
    }

    public void removeItself() {
        Writer.getOut().completed(this.m_coordinator.getXID());
        try {
            this.m_poa.deactivate_object(this.m_poa.servant_to_id((Servant)this));
            this.m_coordinator.removeItself();
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy ex) {
        }
        catch (ServantNotActive servantNotActive) {
            // empty catch block
        }
    }

    public void disableRemove() {
        this.m_disable_remove = true;
    }

    public void enableRemove() {
        this.m_disable_remove = false;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

