/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import org.apache.avalon.framework.logger.Logger;
import org.openorb.ots.Impl.Terminator;

public class TimeOutControl
extends Thread {
    private Terminator m_terminator;
    private int m_time_out;
    private int m_transaction_state;
    private Logger m_logger;
    private static final int IN_PROCESS = 0;
    private static final int FINISHED = 1;

    public TimeOutControl(Terminator term, int time_out, Logger logger) {
        this.m_logger = logger;
        this.m_terminator = term;
        this.m_time_out = time_out;
        this.m_transaction_state = 0;
        this.m_terminator.setTimeOutControl(this);
    }

    public void finish() {
        this.m_transaction_state = 1;
    }

    public void proceed() {
        switch (this.m_transaction_state) {
            case 0: {
                this.m_terminator.proceed_rollback();
                break;
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(this.m_time_out * 1000);
            this.proceed();
        }
        catch (Exception e) {
            this.m_logger.error("OTS TimeoutControl error " + e.toString(), (Throwable)e);
        }
    }
}

