/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.ORB;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitInfo;

public class TransactionalClientInterceptor
extends LocalObject
implements ClientRequestInterceptor,
LogEnabled {
    private ORBInitInfo m_info;
    private int m_slot;
    private Logger m_logger;

    public TransactionalClientInterceptor(ORBInitInfo info, int slot) {
        this.m_info = info;
        this.m_slot = slot;
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        this.getLogger().debug("send_request");
        Any any = null;
        try {
            any = ri.get_slot(this.m_slot);
        }
        catch (InvalidSlot is) {
            this.getLogger().fatalError("invalid slot : " + this.m_slot, (Throwable)is);
            throw new INTERNAL();
        }
        if (any.type().kind().value() == 0 || any.type().kind().value() == 1) {
            return;
        }
        PropagationContext pctx = PropagationContextHelper.extract(any);
        ServiceContext serviceCtx = new ServiceContext();
        serviceCtx.context_id = 0;
        try {
            CodecFactory codecFactory = this.m_info.codec_factory();
            Encoding encoding = new Encoding(0, new Integer(1).byteValue(), new Integer(2).byteValue());
            Codec codec = codecFactory.create_codec(encoding);
            Any pany = ORB.init().create_any();
            PropagationContextHelper.insert(pany, pctx);
            serviceCtx.context_data = codec.encode_value(pany);
        }
        catch (UnknownEncoding ue) {
            this.getLogger().error("Unknown Encoding", (Throwable)ue);
            throw new INTERNAL();
        }
        catch (InvalidTypeForEncoding it) {
            this.getLogger().error("Invalid Type for encoding", (Throwable)it);
            throw new INTERNAL();
        }
        ri.add_request_service_context(serviceCtx, true);
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public String name() {
        return "TransactionalClientInterceptor";
    }

    public void destroy() {
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Logger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = new ConsoleLogger(1);
        }
        return this.m_logger;
    }
}

