/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.log;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.GregorianCalendar;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.PropertyNotFoundException;
import org.openorb.orb.core.ORB;
import org.openorb.ots.Impl.Control;
import org.openorb.ots.Impl.XID;
import org.openorb.ots.log.LogTimer;
import org.openorb.ots.log.Reader;

public class Writer {
    private static final int TR_BEGIN = 0;
    private static final int TR_COMMIT_END = 1;
    private static final int TR_ROLLBACK_BEGIN = 2;
    private static final int TR_ROLLBACK_END = 3;
    private static final int TR_COMMIT_BEGIN = 4;
    private static final int TR_COMMIT_ONE_BEGIN = 5;
    private static final int TR_ROLLBACK_RESOURCE = 6;
    private static final int TR_PREPARE_RESOURCE = 7;
    private static final int TR_PREPARE_BEGIN = 8;
    private static final int TR_PREPARE_END = 9;
    private static final int TR_REGISTER = 10;
    private static final int TR_COMMIT_RESOURCE = 11;
    private static final int TR_COMPLETED = 12;
    private static final int TR_BEGIN_SUB = 13;
    private static final int TR_RECOVERY = 14;
    private static final int TR_PREVIOUS_LOG = 15;
    private static final int TR_UNCOMPLETED = 16;
    private static final int TR_ROLLBACK_ONLY = 17;
    private static Writer s_out;
    private org.omg.CORBA.ORB m_orb;
    private RandomAccessFile m_log;
    private boolean m_log_enable;
    private int m_date_month;
    private int m_date_day;
    private int m_date_year;
    private String m_previous_log;
    private Logger m_logger;
    static /* synthetic */ Class class$org$openorb$ots$log$Writer;

    public static Writer getOut() {
        return s_out;
    }

    protected Writer(org.omg.CORBA.ORB orb, boolean recovery, Logger logger) {
        this.m_orb = orb;
        this.m_log_enable = false;
        this.m_logger = logger;
        ORBLoader cfg = ((ORB)this.m_orb).getLoader();
        String logs = null;
        try {
            logs = cfg.getStringProperty("OTS.log.enable");
        }
        catch (PropertyNotFoundException pnf) {
            this.getLogger().info("Unable to find OTS.log.enable property - not logging transactions");
        }
        if (logs != null && logs.equalsIgnoreCase("true")) {
            try {
                logs = cfg.getStringProperty("OTS.log.directory");
            }
            catch (PropertyNotFoundException pnf) {
                this.getLogger().fatalError("Unable to get the log directory", (Throwable)pnf);
                throw new INITIALIZE();
            }
            if (logs == null) {
                this.getLogger().fatalError("Unable to get the log directory");
                throw new INITIALIZE();
            }
            this.openLog(logs, recovery);
            this.m_log_enable = true;
        }
    }

    private void openLog(String directory, boolean recovery) {
        String log_name = null;
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        this.m_date_month = calendar.get(2) + 1;
        this.m_date_day = calendar.get(5);
        this.m_date_year = calendar.get(1);
        log_name = "openorb_ots_" + (calendar.get(2) + 1) + "_" + calendar.get(5) + "_" + calendar.get(1) + ".log";
        try {
            boolean exist = new File(directory + log_name).exists();
            this.m_previous_log = directory + log_name;
            this.m_log = new RandomAccessFile(directory + log_name, "rw");
            if (!recovery) {
                this.write_last_log(directory + log_name);
            }
            if (exist) {
                this.m_log.seek(this.m_log.length());
            }
        }
        catch (IOException ex) {
            this.getLogger().fatalError("Unable to create Transaction Service log file.", (Throwable)ex);
            throw new INITIALIZE();
        }
        if (!recovery) {
            LogTimer timer = new LogTimer(this.m_date_day);
            timer.setDaemon(true);
            timer.start();
        }
    }

    public void recovery_completed() {
        this.write_last_log(this.m_previous_log);
        LogTimer timer = new LogTimer(this.m_date_day);
        timer.setDaemon(true);
        timer.start();
    }

    public void begin_transaction(Control control) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            XID xid = control.getCoordinator().getXID();
            try {
                this.m_log.writeInt(0);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Begin transaction : " + xid.toString());
        }
    }

    public void begin_transaction_sub(Control control) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            XID xid = control.getCoordinator().getXID();
            try {
                this.m_log.writeInt(13);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Begin transaction as subordonate : " + xid.toString());
        }
    }

    public void rollback_only(XID xid) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(17);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getLogger().debug("Rollback only for : " + xid.toString());
        }
    }

    public void register_resource(XID xid, Resource resource) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(10);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeUTF(this.m_orb.object_to_string((Object)resource));
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Register resource : " + xid.toString());
        }
    }

    public void commit_resource(XID xid, Resource resource) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(11);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeUTF(this.m_orb.object_to_string((Object)resource));
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Commit resource : " + xid.toString());
        }
    }

    public void commit_end(XID xid, Status status) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(1);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeInt(status.value());
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Commit end : " + xid.toString());
        }
    }

    public void commit_begin(XID xid) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(4);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getLogger().debug("Commit begin : " + xid.toString());
        }
    }

    public void commit_one_phase_begin(XID xid, Resource resource) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(5);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeUTF(this.m_orb.object_to_string((Object)resource));
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Commit one phase begin : " + xid.toString());
        }
    }

    public void rollback_end(XID xid, Status status) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(3);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeInt(status.value());
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Rollback end : " + xid.toString());
        }
    }

    public void rollback_begin(XID xid) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(2);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getLogger().debug("Rollback begin : " + xid.toString());
        }
    }

    public void rollback_resource(XID xid, Resource resource) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(6);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeUTF(this.m_orb.object_to_string((Object)resource));
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Rollback resource : " + xid.toString());
        }
    }

    public void prepare_resource(XID xid, Resource resource, Vote vote) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(7);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeUTF(this.m_orb.object_to_string((Object)resource));
                this.m_log.writeInt(vote.value());
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Prepare resource : " + xid.toString());
        }
    }

    public void prepare_begin(XID xid) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(8);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getLogger().debug("Prepare begin : " + xid.toString());
        }
    }

    public void prepare_end(XID xid, Status status, Vote vote) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(9);
                this.m_log.writeUTF(xid.toString());
                this.m_log.writeInt(status.value());
                this.m_log.writeInt(vote.value());
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.getLogger().debug("Prepare end : " + xid.toString());
        }
    }

    public void completed(XID xid) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(12);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getLogger().debug("Transaction completed : " + xid.toString());
        }
    }

    public void uncompleted(XID xid) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(16);
                this.m_log.writeUTF(xid.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void recovery() {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(14);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void previous_log(String previous_log_name) {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.writeInt(15);
                this.m_log.writeUTF(previous_log_name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void changeLog() {
        if (!this.m_log_enable) {
            return;
        }
        Class clazz = class$org$openorb$ots$log$Writer == null ? (class$org$openorb$ots$log$Writer = Writer.class$("org.openorb.ots.log.Writer")) : class$org$openorb$ots$log$Writer;
        synchronized (clazz) {
            try {
                this.m_log.close();
                ORBLoader cfg = ((ORB)this.m_orb).getLoader();
                String log_directory = null;
                try {
                    log_directory = cfg.getStringProperty("OTS.log.directory");
                }
                catch (PropertyNotFoundException pnf) {
                    this.getLogger().error("Unable to find OTS.log.directory property", (Throwable)pnf);
                }
                boolean dateOk = false;
                while (!dateOk) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    int month = calendar.get(2) + 1;
                    int day = calendar.get(5);
                    int year = calendar.get(1);
                    if (year > this.m_date_year) {
                        dateOk = true;
                        continue;
                    }
                    if (month > this.m_date_month) {
                        dateOk = true;
                        continue;
                    }
                    if (day > this.m_date_day) {
                        dateOk = true;
                        continue;
                    }
                    try {
                        Thread.currentThread().wait(30000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                Reader reader = new Reader(this.m_previous_log, this.m_orb, this.getLogger());
                XID[] xids = reader.uncompleted_transactions();
                reader.close();
                String previousLogName = this.m_previous_log;
                this.openLog(log_directory, false);
                this.previous_log(previousLogName);
                int i = 0;
                while (i < xids.length) {
                    this.uncompleted(xids[i]);
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void write_last_log(String last_log) {
        ORBLoader cfg = ((ORB)this.m_orb).getLoader();
        String directory = null;
        try {
            directory = cfg.getStringProperty("OTS.log.directory");
        }
        catch (PropertyNotFoundException pnf) {
            this.getLogger().error("Unable to find OTS.log.directory property", (Throwable)pnf);
            return;
        }
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        String lock_last = directory + "ots.log";
        try {
            FileOutputStream lock = new FileOutputStream(lock_last);
            DataOutputStream writer = new DataOutputStream(lock);
            writer.writeUTF(last_log);
            writer.close();
            lock.close();
        }
        catch (IOException ex) {
            this.getLogger().error("Unable to write lock file for log: " + lock_last);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    public static void newWriter(org.omg.CORBA.ORB orb, boolean recovery, Logger logger) {
        s_out = new Writer(orb, recovery, logger);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

