/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.Translator;
import org.xml.sax.XMLReader;

public class AWTStarter
extends CommandLineStarter {
    private PreviewDialog frame;
    private Translator translator;
    private Driver driver;
    private XMLReader parser;

    public AWTStarter(CommandLineOptions commandLineOptions) throws FOPException {
        super(commandLineOptions);
        this.init();
    }

    private void init() throws FOPException {
        String language = this.commandLineOptions.getLanguage();
        this.translator = language == null ? new Translator(Locale.getDefault()) : new Translator(new Locale(language, ""));
        AWTRenderer renderer = new AWTRenderer(this.translator);
        this.frame = this.createPreviewDialog(renderer, this.translator);
        renderer.setComponent(this.frame);
        this.driver = new Driver();
        this.driver.setRenderer(renderer);
        this.parser = this.inputHandler.getParser();
        if (this.parser == null) {
            throw new FOPException("Unable to create SAX parser");
        }
    }

    public void run() throws FOPException {
        this.driver.reset();
        try {
            this.frame.setStatus(this.translator.getString("Status.Build.FO.tree"));
            this.driver.render(this.parser, this.inputHandler.getInputSource());
            this.frame.setStatus(this.translator.getString("Status.Show"));
            this.frame.showPage();
        }
        catch (Exception e) {
            this.frame.reportException(e);
        }
    }

    private PreviewDialog createPreviewDialog(AWTRenderer renderer, Translator res) {
        PreviewDialog frame = new PreviewDialog(this, renderer, res);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                System.exit(0);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        return frame;
    }
}

