/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.StorePagesModel;
import org.apache.fop.area.TreeExt;
import org.apache.fop.fo.Title;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.render.Renderer;
import org.xml.sax.SAXException;

public class LayoutHandler
extends StructureHandler {
    private final boolean collectStatistics = true;
    private static final boolean MEM_PROFILE_WITH_GC = false;
    private Runtime runtime;
    private int pageCount;
    private long initialMemory;
    private long startTime;
    private OutputStream outputStream;
    private Renderer renderer;
    private FontInfo fontInfo = new FontInfo();
    private AreaTree areaTree;
    private AreaTreeModel atModel;

    public LayoutHandler(OutputStream outputStream, Renderer renderer, boolean store) {
        this.runtime = Runtime.getRuntime();
        this.outputStream = outputStream;
        this.renderer = renderer;
        this.areaTree = new AreaTree();
        this.atModel = AreaTree.createRenderPagesModel(renderer);
        this.areaTree.setTreeModel(this.atModel);
    }

    public AreaTree getAreaTree() {
        return this.areaTree;
    }

    public void startDocument() throws SAXException {
        this.pageCount = 0;
        this.initialMemory = this.runtime.totalMemory() - this.runtime.freeMemory();
        this.startTime = System.currentTimeMillis();
        try {
            this.renderer.setupFontInfo(this.fontInfo);
            if (!this.fontInfo.isSetupValid()) {
                throw new SAXException(new FOPException("No default font defined by OutputConverter"));
            }
            this.renderer.startRenderer(this.outputStream);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.areaTree.endDocument();
            this.renderer.stopRenderer();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        long memoryNow = this.runtime.totalMemory() - this.runtime.freeMemory();
        long memoryUsed = (memoryNow - this.initialMemory) / 1024L;
        long timeUsed = System.currentTimeMillis() - this.startTime;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Initial heap size: " + this.initialMemory / 1024L + "Kb");
            this.getLogger().debug("Current heap size: " + memoryNow / 1024L + "Kb");
            this.getLogger().debug("Total memory used: " + memoryUsed + "Kb");
            this.getLogger().debug("  Memory use is indicative; no GC was performed");
            this.getLogger().debug("  These figures should not be used comparatively");
            this.getLogger().debug("Total time used: " + timeUsed + "ms");
            this.getLogger().debug("Pages rendered: " + this.pageCount);
            if (this.pageCount > 0) {
                this.getLogger().debug("Avg render time: " + timeUsed / (long)this.pageCount + "ms/page");
            }
        }
    }

    public void startPageSequence(PageSequence pageSeq, Title seqTitle, LayoutMasterSet lms) {
        org.apache.fop.area.Title title = null;
        if (seqTitle != null) {
            title = seqTitle.getTitleArea();
        }
        this.areaTree.startPageSequence(title);
    }

    public void endPageSequence(PageSequence pageSequence) throws FOPException {
        long memoryNow = this.runtime.totalMemory() - this.runtime.freeMemory();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Current heap size: " + memoryNow / 1024L + "Kb");
        }
        pageSequence.format(this.areaTree);
    }

    private void processAreaTree(StorePagesModel model) throws FOPException {
        int count = 0;
        int seqc = model.getPageSequenceCount();
        while (count < seqc) {
            org.apache.fop.area.Title title = model.getTitle(count);
            this.renderer.startPageSequence(title);
            int pagec = model.getPageCount(count);
            int c = 0;
            while (c < pagec) {
                try {
                    this.renderer.renderPage(model.getPage(count, c));
                }
                catch (IOException ioex) {
                    throw new FOPException("I/O Error rendering page", ioex);
                }
                ++c;
            }
            ++count;
        }
        List list = model.getEndExtensions();
        count = 0;
        while (count < list.size()) {
            TreeExt ext = (TreeExt)list.get(count);
            this.renderer.renderExtension(ext);
            ++count;
        }
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }
}

