/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.area.Page;
import org.apache.fop.area.Resolveable;

public class PageViewport
implements Resolveable,
Cloneable {
    private Page page;
    private Rectangle2D viewArea;
    private boolean clip = false;
    private String pageNumber = null;
    private Map idReferences = null;
    private Map unresolved = null;
    private Map pendingResolved = null;
    private Map markerFirstStart = null;
    private Map markerLastStart = null;
    private Map markerFirstAny = null;
    private Map markerLastEnd = null;
    private Map markerLastAny = null;

    public PageViewport(Page p, Rectangle2D bounds) {
        this.page = p;
        this.viewArea = bounds;
    }

    public void setClip(boolean c) {
        this.clip = c;
    }

    public Rectangle2D getViewArea() {
        return this.viewArea;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPageNumber(String num) {
        this.pageNumber = num;
    }

    public String getPageNumber() {
        return this.pageNumber;
    }

    public String getKey() {
        return this.toString();
    }

    public void addUnresolvedID(String id, Resolveable res) {
        ArrayList<Resolveable> list;
        if (this.unresolved == null) {
            this.unresolved = new HashMap();
        }
        if ((list = (ArrayList<Resolveable>)this.unresolved.get(id)) == null) {
            list = new ArrayList<Resolveable>();
            this.unresolved.put(id, list);
        }
        list.add(res);
    }

    public boolean isResolved() {
        return this.unresolved == null;
    }

    public String[] getIDs() {
        return null;
    }

    public void resolve(String id, List pages) {
        List todo;
        if (this.page == null) {
            if (this.pendingResolved == null) {
                this.pendingResolved = new HashMap();
            }
            this.pendingResolved.put(id, pages);
        } else if (this.unresolved != null && (todo = (List)this.unresolved.get(id)) != null) {
            int count = 0;
            while (count < todo.size()) {
                Resolveable res = (Resolveable)todo.get(count);
                res.resolve(id, pages);
                ++count;
            }
        }
        if (this.unresolved != null) {
            this.unresolved.remove(id);
            if (this.unresolved.isEmpty()) {
                this.unresolved = null;
            }
        }
    }

    public void addMarkers(Map marks, boolean start, boolean isfirst) {
        if (start) {
            if (isfirst) {
                if (this.markerFirstStart == null) {
                    this.markerFirstStart = new HashMap();
                }
                if (this.markerFirstAny == null) {
                    this.markerFirstAny = new HashMap();
                }
                Iterator iter = marks.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    if (!this.markerFirstStart.containsKey(key)) {
                        this.markerFirstStart.put(key, marks.get(key));
                    }
                    if (this.markerFirstAny.containsKey(key)) continue;
                    this.markerFirstAny.put(key, marks.get(key));
                }
                if (this.markerLastStart == null) {
                    this.markerLastStart = new HashMap();
                }
                this.markerLastStart.putAll(marks);
            } else {
                if (this.markerFirstAny == null) {
                    this.markerFirstAny = new HashMap();
                }
                Iterator iter = marks.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    if (this.markerFirstAny.containsKey(key)) continue;
                    this.markerFirstAny.put(key, marks.get(key));
                }
            }
        } else {
            if (!isfirst) {
                if (this.markerLastEnd == null) {
                    this.markerLastEnd = new HashMap();
                }
                this.markerLastEnd.putAll(marks);
            }
            if (this.markerLastAny == null) {
                this.markerLastAny = new HashMap();
            }
            this.markerLastAny.putAll(marks);
        }
    }

    public Object getMarker(String name, int pos) {
        Object mark = null;
        switch (pos) {
            case 34: {
                if (this.markerFirstStart != null) {
                    mark = this.markerFirstStart.get(name);
                }
                if (mark != null || this.markerFirstAny == null) break;
                mark = this.markerFirstAny.get(name);
                break;
            }
            case 30: {
                if (this.markerFirstAny == null) break;
                mark = this.markerFirstAny.get(name);
                break;
            }
            case 48: {
                if (this.markerLastStart != null) {
                    mark = this.markerLastStart.get(name);
                }
                if (mark != null || this.markerLastAny == null) break;
                mark = this.markerLastAny.get(name);
                break;
            }
            case 45: {
                if (this.markerLastEnd != null) {
                    mark = this.markerLastEnd.get(name);
                }
                if (mark != null || this.markerLastAny == null) break;
                mark = this.markerLastAny.get(name);
            }
        }
        return mark;
    }

    public void savePage(ObjectOutputStream out) throws Exception {
        this.page.setUnresolvedReferences(this.unresolved);
        out.writeObject(this.page);
        this.page = null;
    }

    public void loadPage(ObjectInputStream in) throws Exception {
        this.page = (Page)in.readObject();
        this.unresolved = this.page.getUnresolvedReferences();
        if (this.unresolved != null && this.pendingResolved != null) {
            Iterator iter = this.pendingResolved.keySet().iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                this.resolve(id, (List)this.pendingResolved.get(id));
            }
            this.pendingResolved = null;
        }
    }

    public Object clone() {
        Page p = (Page)this.page.clone();
        PageViewport ret = new PageViewport(p, (Rectangle2D)this.viewArea.clone());
        return ret;
    }

    public void clear() {
        this.page = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("PageViewport: page=");
        sb.append(this.getPageNumber());
        return sb.toString();
    }
}

