/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.apache.fop.area.Area;
import org.apache.fop.area.RegionReference;

public class RegionViewport
extends Area
implements Cloneable {
    private RegionReference region;
    private Rectangle2D viewArea;
    private boolean clip = false;

    public RegionViewport(Rectangle2D viewArea) {
        this.viewArea = viewArea;
    }

    public void setRegion(RegionReference reg) {
        this.region = reg;
    }

    public RegionReference getRegion() {
        return this.region;
    }

    public void setClip(boolean c) {
        this.clip = c;
    }

    public Rectangle2D getViewArea() {
        return this.viewArea;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeFloat((float)this.viewArea.getX());
        out.writeFloat((float)this.viewArea.getY());
        out.writeFloat((float)this.viewArea.getWidth());
        out.writeFloat((float)this.viewArea.getHeight());
        out.writeBoolean(this.clip);
        out.writeObject(this.props);
        out.writeObject(this.region);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.viewArea = new Rectangle2D.Float(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
        this.clip = in.readBoolean();
        this.props = (HashMap)in.readObject();
        this.setRegion((RegionReference)in.readObject());
    }

    public Object clone() {
        RegionViewport rv = new RegionViewport((Rectangle2D)this.viewArea.clone());
        rv.region = (RegionReference)this.region.clone();
        if (this.props != null) {
            rv.props = (HashMap)this.props.clone();
        }
        return rv;
    }
}

