/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;

public class LengthBase
implements PercentBase {
    public static final int CUSTOM_BASE = 0;
    public static final int FONTSIZE = 1;
    public static final int INH_FONTSIZE = 2;
    public static final int CONTAINING_BOX = 3;
    public static final int CONTAINING_REFAREA = 4;
    protected FObj parentFO;
    private PropertyList propertyList;
    private int iBaseType;

    public LengthBase(FObj parentFO, PropertyList plist, int iBaseType) {
        this.parentFO = parentFO;
        this.propertyList = plist;
        this.iBaseType = iBaseType;
    }

    protected FObj getParentFO() {
        return this.parentFO;
    }

    protected PropertyList getPropertyList() {
        return this.propertyList;
    }

    public int getDimension() {
        return 1;
    }

    public double getBaseValue() {
        return 1.0;
    }

    public int getBaseLength() {
        switch (this.iBaseType) {
            case 1: {
                return this.propertyList.get("font-size").getLength().getValue();
            }
            case 2: {
                return this.propertyList.getInherited("font-size").getLength().getValue();
            }
            case 4: {
                return 0;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }
}

