/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;

public class ColorProfile
extends FObj {
    private int intent;
    private String src;
    private String profileName;
    private ICC_ColorSpace colorSpace = null;

    protected ColorProfile(FONode parent) {
        super(parent);
    }

    public void end() {
        this.src = this.properties.get("src").getString();
        this.profileName = this.properties.get("color-profile-name").getString();
        this.intent = this.properties.get("rendering-intent").getEnum();
        this.properties = null;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public ColorType getColor(int[] colorVals, int defR, int defG, int defB) {
        return null;
    }

    private void load() {
        try {
            URL url = new URL(this.src);
            InputStream is = url.openStream();
            ICC_Profile iccProfile = ICC_Profile.getInstance(is);
            this.colorSpace = new ICC_ColorSpace(iccProfile);
        }
        catch (IOException ioe) {
            this.getLogger().error("Could not read Color Profile src", (Throwable)ioe);
        }
        catch (IllegalArgumentException iae) {
            this.getLogger().error("Color Profile src not an ICC Profile", (Throwable)iae);
        }
    }
}

