/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListBuilder;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.properties.FOPropertyMapping;
import org.xml.sax.Attributes;

public class FObj
extends FONode {
    private static final String FO_URI = "http://www.w3.org/1999/XSL/Format";
    protected static PropertyListBuilder plb = null;
    protected StructureHandler structHandler;
    public PropertyList properties;
    protected PropertyManager propMgr;
    protected String id = null;
    protected ArrayList children = null;
    protected Map markers = null;

    public FObj(FONode parent) {
        super(parent);
    }

    public void setName(String str) {
        this.name = "fo:" + str;
    }

    protected PropertyListBuilder getListBuilder() {
        if (plb == null) {
            plb = new PropertyListBuilder();
            plb.addList(FOPropertyMapping.getGenericMappings());
            Iterator iter = FOPropertyMapping.getElementMappings().iterator();
            while (iter.hasNext()) {
                String elem = (String)iter.next();
                plb.addElementList(elem, FOPropertyMapping.getElementMapping(elem));
            }
        }
        return plb;
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        FONode par = this.parent;
        while (par != null && !(par instanceof FObj)) {
            par = par.parent;
        }
        PropertyList props = null;
        if (par != null) {
            props = ((FObj)par).properties;
        }
        this.properties = this.getListBuilder().makeList(FO_URI, this.name, attlist, props, (FObj)par);
        this.properties.setFObj(this);
        this.propMgr = this.makePropertyManager(this.properties);
        this.setWritingMode();
    }

    protected PropertyManager makePropertyManager(PropertyList propertyList) {
        return new PropertyManager(propertyList);
    }

    protected void addChild(FONode child) {
        if (this.containsMarkers() && child.isMarker()) {
            this.addMarker((Marker)child);
        } else {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }
    }

    public void setStructHandler(StructureHandler st) {
        this.structHandler = st;
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    protected void setupID() {
        String str;
        Property prop = this.properties.get("id");
        if (prop != null && (str = prop.getString()) != null && !str.equals("")) {
            Set idrefs = this.structHandler.getIDReferences();
            if (!idrefs.contains(str)) {
                this.id = str;
                idrefs.add(this.id);
            } else {
                this.getLogger().warn("duplicate id:" + str + " ignored");
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public boolean generatesReferenceAreas() {
        return false;
    }

    public boolean generatesInlineAreas() {
        return true;
    }

    protected boolean containsMarkers() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void setWritingMode() {
        FONode parent;
        FObj p = this;
        while (!p.generatesReferenceAreas() && (parent = p.getParent()) != null && parent instanceof FObj) {
            void var2_2;
            p = (FObj)var2_2;
        }
        this.properties.setWritingMode(p.getProperty("writing-mode").getEnum());
    }

    public void addLayoutManager(List list) {
    }

    public ListIterator getChildren() {
        if (this.children != null) {
            return this.children.listIterator();
        }
        return null;
    }

    public ListIterator getChildren(FONode childNode) {
        int i;
        if (this.children != null && (i = this.children.indexOf(childNode)) >= 0) {
            return this.children.listIterator(i);
        }
        return null;
    }

    public void addMarker(Marker marker) {
        String mcname = marker.getMarkerClassName();
        if (this.children != null) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                FONode node = (FONode)iter.next();
                if (node instanceof FOText) {
                    FOText text = (FOText)node;
                    if (text.willCreateArea()) {
                        this.getLogger().error("fo:marker must be an initial child: " + mcname);
                        return;
                    }
                    iter.remove();
                    continue;
                }
                this.getLogger().error("fo:marker must be an initial child: " + mcname);
                return;
            }
        }
        if (this.markers == null) {
            this.markers = new HashMap();
        }
        if (!this.markers.containsKey(mcname)) {
            this.markers.put(mcname, marker);
        } else {
            this.getLogger().error("fo:marker 'marker-class-name' must be unique for same parent: " + mcname);
        }
    }

    public boolean hasMarkers() {
        return this.markers != null && !this.markers.isEmpty();
    }

    public Map getMarkers() {
        return this.markers;
    }

    public PropertyManager getPropertyManager() {
        return this.propMgr;
    }
}

